#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"

#include "Port.h"
#include "EnvServer.h"
#include "StatusLED.h"
#include "Sensor.h"
#include "Twitter.h"

extern EthernetInterface eth;
extern Serial pc;

Serial pc(USBTX, USBRX);
EthernetInterface eth;

int main()
{
    int ret;

    // Timer for Hearbeat LED
    RtosTimer HBLEDTickTimer(HBLedTicker,osTimerPeriodic);
        
    // Initialize COM Port
    pc.baud(115200);

    // Initialize Status LED
    pOBStatusLED=new StatusLED(new DigitalOut(LED_G),new DigitalOut(LED_R),new DigitalOut(LED_B));

    // Initialize Sensor with I2C port
    pSensor=new BME280(PTE25, PTE24);
    pLumSensor=new TSL2561_I2C(PTE25, PTE24);
    pLumSensor->enablePower();

    //Initialize ethernet interface
    eth.init(); //Use DHCP
    printf("Initialized, MAC: %s\n", eth.getMACAddress());
    while ((ret = eth.connect()) != 0) {
        printf("Error eth.connect() - ret = %d\n", ret);
    }
    printf("Connected, IP: %s, MASK: %s, GW: %s\n",
           eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());

    // Correct internal RTC by connecting NTP Server
    updateTime();

    // Start Heartbeat LED Tick Thread
    HBLEDTickTimer.start(HBLED_CYCLE);

    // Start Server Thread
    Thread ThServer(EnvServer);

    // Start Twitter Client Thread
    Thread TwetterClientTh(TwitterClient,NULL,osPriorityNormal,16384);
    
    // wait forever
    Thread::wait(osWaitForever);
}