#include <string.h>
#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "OAuth4Tw.h"

#include "Twitter.h"
#include "OAuthKey.h"
#include "Sensor.h"

// NTP Client to correct RTC
NTPClient ntp;

// Twitter API URL
const char url[] = "https://api.twitter.com/1.1/statuses/update.json";

char response_buffer[RESPONSE_BUFFER_SIZE];
HTTPText response(response_buffer, sizeof(response_buffer));

void TwitterClient(void const *arg)
{
    int i;

    for(;;) {
        EnvTweet();
        example_getUserData();
        for(i=0; i<10; i++) {
            Thread::wait(60*1000);
        }
    }
}


void updateTime()
{
    printf("Trying to update time...\n");

    time_t ctTime;
    NTPResult result;

    while (1) {
        //result = ntp.setTime("pool.ntp.org");
        //result = ntp.setTime("pool.ntp.org", NTP_DEFAULT_PORT, 2000);
        result = ntp.setTime("ntp.nict.jp");

        if (result == NTP_OK) {
            time(&ctTime);
            printf("Time is set to (UTC): %s\n", ctime(&ctTime));
            break;
        }

        switch (result) {
            case NTP_CONN:      ///<Connection error
                printf("Connection error\n");
                break;
            case NTP_TIMEOUT:   ///<Connection timeout
                printf("Connection timeout\n");
                break;
            case NTP_PRTCL:     ///<Protocol error
                printf("Protocol error\n");
                break;
            case NTP_DNS:       ///<Could not resolve name
                printf("Could not resolve name\n");
                break;
            default:
                printf("Error result=%d\n", result);
                break;
        }

        wait(5);
    }
}

void EnvTweet()
{

    std::vector<std::string> post;
    post.reserve(3);

    struct tm tmptr;
    char tmstr[34];
    char status[150];
    char location_lat[24];
    char location_long[24];

    time_t ctTime;
    time(&ctTime);
    ctTime += 9 * 60 * 60;  // Timezone: JST(+9h)
    localtime_r(&ctTime, &tmptr);

    // Tweets in Japanese
    strftime(tmstr, sizeof(tmstr), "%Y年%m月%d日 %H時%M分%S秒", &tmptr);
    snprintf(status, sizeof(status), "status=只今%sですよ～\n温度：%2.2f℃ 気圧：%04.2fhPa 湿度：%2.2f%% 照度：%5.2flx",
             tmstr, pSensor->getTemperature(), pSensor->getPressure(), pSensor->getHumidity(),pLumSensor->getLux());
    post.push_back(status);

    // Option: add Location information
    // snprintf(location_lat, sizeof(location_lat), "lat=%f", 35.359577);
    // snprintf(location_long, sizeof(location_long), "long=%f", 138.731414);
    // post.push_back(location_lat);
    // post.push_back(location_long);

    HTTPResult result = oa4t.post(url, &post, &response);

    if (result == HTTP_OK) {
        printf("POST success.\n%s\n", response_buffer);
    } else {
        printf("POST error. (result = %d)\n", result);
    }
}

void example_getUserData()
{
    const char url[] = "https://api.twitter.com/1.1/users/show.json"
                       "?screen_name=twitter";

    HTTPResult result = oa4t.get(url, &response);

    if (result == HTTP_OK) {
        printf("GET success.\n%s\n", response_buffer);
    } else {
        printf("GET error. (result = %d)\n", result);
    }
}