/* mbed MH-Z19 Library
 * Copyright (c) 2016, zeus3110
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "MH_Z19.h"

MH_Z19::MH_Z19(PinName p) : Port(p) {
    Port.rise(this, &MH_Z19::rise);
    Port.fall(this, &MH_Z19::fall);
    OnWidth=2;
    T.start();
}

int MH_Z19::ReadCO2PPM() {
    
    return ((CO2_MAX_PPM)*(OnWidth-2)/(PWM_CYCLE_MS-4));

}
    

void MH_Z19::rise() {
    T.reset();
}

void MH_Z19::fall() {
    OnWidth=T.read_ms();
}
