#include "mbed.h"
#include "STM32F4_RNG.h"
#include "DHT.h"
#include "BMP180.h"
Serial pc(USBTX, USBRX);
Serial esp(D8, D2); // tx D8, rx D2
DigitalOut reset(D4);
Timer t;

STM32F4_RNG RANDOM1;

int mycount,ended,timeout;
char buf[1024];
char snd[255];
char ssid[32] = "King5";     // enter WiFi router ssid inside the quotes
char pwd [32] = "88888888"; // enter WiFi router password inside the quotes

char apiKey[32] = "UADVBX13ELBYAO7M";

unsigned long ranval;

#define TEMPVAL 23
#define HUMIVAL 67
#define RAYVAL 45
#define PREVAL 340

int tempVal = 23;
int humiVal = 67;
int rayVal = 45;
int pressVal = 340;
unsigned long randVal;
unsigned char shortrandVal= 0;
float fhumi,ftemp,fray,fpress;


void SendCMD(),getreply(),ESPconfig(),ESPsetbaudrate(),HTTPConfig(),PostData();
AnalogIn analog_value(A0);



DHT devDht(D7,DHT11);
BMP180 bmp180(PB_14, PB_13);



int main()
{
    reset=0; //hardware reset for 8266
    pc.baud(115200);  // set what you want here depending on your terminal program speed
    pc.printf("\f\n\r-------------ESP8266 Hardware Rese444t-------------\n\r");
    wait(0.5);
    reset=1;
    timeout=2;
    getreply();
    esp.baud(115200);   // change this to the new ESP8266 baudrate if it is changed at any time.
    //ESPsetbaudrate();   //******************  include this routine to set a different ESP8266 baudrate  ******************
    //ESPconfig();        //******************  include Config to set the ESP8266 configuration  ***********************
    

    HTTPConfig();
    
 
    // continuosly get AP list and IP
    while(1)
    {
       //pc.printf("get data from server\r\n");

     
       PostData();
       
        
 
    }

}
// Sets new ESP8266 baurate, change the esp.baud(xxxxx) to match your new setting once this has been executed
void ESPsetbaudrate()
{
    strcpy(snd, "AT+CIOBAUD=115200\r\n");   // change the numeric value to the required baudrate
    SendCMD();
}
//  +++++++++++++++++++++++++++++++++ This is for ESP8266 config only, run this once to set up the ESP8266 +++++++++++++++
void ESPconfig()
{

}
void SendCMD()
{
    esp.printf("%s", snd);
}
void getreply()
{
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;
    mycount=0;
    while(!ended) {
        if(esp.readable()) {
            buf[mycount] = esp.getc();
            mycount++;
        }
        if(t.read() > timeout) {
            ended = 1;
            t.stop();
            t.reset();
        }
    }
    buf[mycount]=0;
    pc.printf("At respon:%s\r\n",buf);
    
    
}

void HTTPConfig()
{
    pc.printf("\n---------- Get Version ----------\r\n");
    strcpy(snd,"AT+GMR\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);
    wait(3);  
    // set CWMODE to 1=Station,2=AP,3=BOTH, default mode 1 (Station)
    pc.printf("\n---------- Setting Mode ----------\r\n");
    strcpy(snd, "AT+CWMODE_DEF=1\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);
    wait(2);  
    
    pc.printf("\n---------- Connecting to AP ----------\r\n");
    pc.printf("ssid = %s   pwd = %s\r\n",ssid,pwd);
    strcpy(snd, "AT+CWJAP_DEF=\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\"\r\n");
    SendCMD();
    timeout=10;
    getreply();
    pc.printf(buf);
    wait(5);
  
    pc.printf("\n-----------set to auto connect -----\r\n");
    strcpy(snd,"AT+CWAUTOCONN=1\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);
    wait(2); 
 
     pc.printf("\n-----------set sigle connect -----\r\n");
    strcpy(snd,"AT+CIPMUX=0\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);
    wait(2); 
 
    pc.printf("\n------------connect to server --------\r\n");
    strcpy(snd,"AT+CIPSTART=\"TCP\",\"api.thingspeak.com\",80\r\n");  
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);
    wait(2); 
  
 
    pc.printf("\n------------set to touchuan --------\r\n");  
    strcpy(snd,"AT+CIPMODE=1\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);
    wait(2); 
    
    pc.printf("\n-----------starting send--------\r\n");
    strcpy(snd,"AT+CIPSEND\r\n");       
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);
    wait(2); 
    
    

    
}
char postStr[256];
void PostData()
{
       int len;
        
        
        if(devDht.readData() == ERROR_NONE)
        {
            fhumi = devDht.ReadHumidity();
            ftemp = devDht.ReadTemperature(CELCIUS);
            pc.printf("temp:%4.1f\thumi:%4.1f\n",ftemp,fhumi);
        }      
        fray = analog_value.read()*3300;
        
        bmp180.normalize(); 
        fpress = bmp180.read_pressure();
        //pressVal = bmp180.read_temperature();
       
       wait(2); 
       //len = sprintf(snd,"GET https://api.thingspeak.com/update?api_key=07A5WIB5QT14WRGV&field1=%d&field2=%d&field3=%d&field4=%d\r\n",tempVal,humiVal,pressVal,rayVal); 
       len = sprintf(snd,"GET https://api.thingspeak.com/update?api_key=07A5WIB5QT14WRGV&field1=%.1f&field2=%.1f&field3=%.1f&field4=%.2f\r\n",ftemp,fhumi,fpress,fray); 
       
       SendCMD(); 
 
       timeout=10;
       getreply();
       pc.printf(buf);
       
       pc.printf("\r\n%s",snd);
       wait(28);     
    
}

