/* 
 * Copyright (c) 2012-2016 Sagawa Electronics,inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"
#include "TB6612.h"
#include "SoftPWM.h"

DigitalOut led1(P2_11);     // LDE1 setting.
DigitalOut led2(P0_2);      // LDE2 setting.
DigitalOut led3(P0_7);      // LDE3 setting.
DigitalOut led4(P0_3);      // LDE4 setting.

AnalogIn ad0(P0_11);        //AD0port setting.
AnalogIn ad1(P1_0);         //AD1port setting.
AnalogIn ad2(P1_1);         //AD2port setting.
AnalogIn ad3(P1_2);         //AD3port setting.
AnalogIn ad5(P1_4);         //AD5port setting.
AnalogIn ad7(P1_11);        //AD7port setting.

TB6612 motor1a(P2_7,P2_9,P2_8);  //TB6612 setting.
TB6612 motor1b(P2_4,P2_6,P2_5);  //TB6612 setting.

Serial pc(P1_7, P1_6);


int main() {
    pc.baud(19200);
    
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0;
    motor1a = 0.0;
    motor1b = 0.0;
    
    while(1) {
        
        led1 = 1;         // LDE1 enable.
        motor1a = 0.2;    // Motor1A forward.
        wait(1.0);        //wait 1 second.
        led1 = 0;         // LDE1 disable.
        
        led2 = 1;         // LDE2 enable.
        motor1a = -0.2;   // Motor1A reversal.
        wait(1.0);        //wait 1 second.
        led2 = 0;         // LDE1 disable.

        motor1a = 0.0;    // Motor1A brake.
        
        led3 = 1;         // LDE3 enable.
        motor1b = 0.2;    // Motor1B forward.
        wait(1.0);        //wait 1 second.
        led3 = 0;         // LDE1 disable.
        
        led4 = 1;         // LDE4 enable.
        motor1b = -0.2;   // Motor1B reversal.
        wait(1.0);        //wait 1 second.
        led4 = 0;         // LDE1 disable.
        
        motor1b = 0.0;    // Motor1B brake.
        
        pc.printf("check_ok \r\n");
    }
}
