#include "TB6612.h"

// TB6612 Class Constructor
TB6612::TB6612(PinName pwm, PinName fwd, PinName rev):
        _pwm(pwm), _fwd(fwd), _rev(rev) {

    _fwd = 0;
    _rev = 0;
    _pwm = 0.0;
    stat = 0;
    _pwm.period(0.001);
    
}

// Speed Control
//  arg
//   float speed -1.0 - 0.0 - 1.0
float TB6612::speed(float speed) {
    
    
    
    if( speed > 0.0 )
    {
        if( speed > 0.7)    speed = 0.7;
        _pwm = speed;
        _fwd = 1;
        _rev = 0;
        stat = 1;
    }
    else if( speed < 0.0 )
    {
        if( speed < -0.7)    speed = -0.7;
        _pwm = -speed;
        _fwd = 0;
        _rev = 1;
        stat = -1;
    }
    else
    {
        _fwd = 1;
        _rev = 1;
        stat = 0;
    }
    return speed==0 ? 0 : speed > 0 ? 1 : -1;
}