#include "mbed.h"
#include "x_nucleo_53l0a1.h"
#include <stdio.h>

#define VL53L0_I2C_SDA   D4 
#define VL53L0_I2C_SCL   D5 

static X_NUCLEO_53L0A1 *board=NULL;
Serial pc(USBTX, USBRX);
Serial pc2(D1,D0);


DigitalOut myled(LED1);


int main()
{   
   int status,i,add,ds[12];
   uint32_t distance;
   pc.baud(115200);
   pc2.baud(115200);

   DevI2C *device_i2c =new DevI2C(VL53L0_I2C_SDA, VL53L0_I2C_SCL);     
        
   board=X_NUCLEO_53L0A1::Instance(device_i2c, A2, D8, D2);

   status=board->InitBoard();
   
   for(i = 0; i <= 10; i++) {
       ds[i] = 0;
    }
    myled = 1;
   while(1)
   {
       for(i = 0; i <= 2; i++) {
           ds[i] = ds [i+1];
           }
       status = board->sensor_centre->GetDistance(&distance);
       ds[2] = distance;
       if(ds[2] == 0){
           ds[2] = ds[1];
           }
       for(i = 0; i <= 2; i++) {
           add = ds[i] + add;
           }
       add = add/30;
       
       pc.printf("pc%03d\r\n", add);
       pc2.printf("a%03d", add);
       
       
        if(add > 4)
        {
            myled = 1;
        }
        else
        {
            myled = 0;
        }
   }

}

