/*
*
* Connections
* L432KC D3   --- SS PmodMIC3
* L432KC D12  --- MISO PmodMIC3
* L432KC D13  --- SCK PmodMIC3
* GND         --- GND PmodMIC3
* Vcc         --- VCC PmodMIC3
*
* L432KC A5   --- SS PmodOLEDrgb
* L432KC D11  --- MOSI PmodOLEDrgb
* L432KC D13  --- SCK PmodOLEDrgb
* GND         --- GND PmodOLEDrgb
* VCC         --- VCC PmodOLEDrgb
* L432KC D10  --- D/C PmodOLEDrgb
* L432KC D8   --- RES PmodOLEDrgb
* VCC         --- VCCEN PmodOLEDrgb
* VCC         --- PMODEN PmodOLEDrgb
*
* NUCLEO-L432KC
* Pmod MIC3
* Pmod OLEDrgb
*
* Reference - Timo Karppinen - Pmod_MIC3_Microphone_L432KC_OS6,
* McLab10_OLEDrgb_L432KC_OS60_tk2
*
**************************************************/
#include  "mbed.h"
#include "Adafruit_SSD1331.h"
#include "Adafruit_GFX.h"

SPI spi(D11, D12, D13); // mosi, miso, sclk

Adafruit_SSD1331 OLED(A5, D8, D10, D11, NC, D13); // cs, res, dc, mosi, (nc), sck

DigitalOut mic3cs(D3);
DigitalOut oledcs(A5);
DigitalOut LED(D9);



// Definition of colours on the OLED display
#define Black 0x0000
#define Blue 0x001F
#define Red 0xF800
#define Green 0x07E0
#define Cyan 0x07FF
#define Magenta 0xF81F
#define Yellow 0xFFE0
#define White 0xFFFF


int raw = 0;        // 16 bits from MIC3
int sound32bit = 0;
int sound = 0;
int delayCount = 0;
int resetCount = 0;

//Function declaration
void delayCalc();


int main()
{
    oledcs.write(0);
       
    OLED.begin(); // initialization of display object
    OLED.clearScreen();
    OLED.fillScreen(Black); // background screen in black
    OLED.setTextColor(Cyan); // colour of text in cyan
    OLED.setTextSize(2);
    
    ThisThread::sleep_for(1000ms);
    
    
    // Chip must be deselected
    mic3cs.write(1);
    oledcs.write(1);

    // Setup the spi for 16 bit data, low steady state clock,
    // rising edge capture, with a 1MHz clock rate
    spi.format(16, 0);
    spi.frequency(1000000);     
    ThisThread::sleep_for(100ms);
    
    while(1){
    // Select the device by setting chip select low
    mic3cs.write(0);
    ThisThread::sleep_for(1ms);  // > 100 ns for the MAX31855
    
    // Send 0x0000 to nowhere to read the 16 bits
    raw = spi.write(0x0000);
    
    ThisThread::sleep_for(1ms);

    // Deselect the device
    mic3cs.write(1);
    
    
    printf("16 bits MIC3 = 0x%X", raw);
    
    sound32bit = raw << 22; // 22 bits to the left to create 32 bit two's complement
    sound = sound32bit / 16777216; // 2 exp24 = 16 7777 216  means shifting 24 bits left without shifting the sign!
    
    if (sound < 0){ // Converts negative values to positive.
        sound = sound = -sound;
        }
    
    printf("   sound 12 bit = %d\n", sound);
    
    delayCalc();
    
}
}

void delayCalc(){ // Calculates how many times sound exceeds sound level 5
    
    if (sound => 5){
        LED.write(1);
        delayCount ++; // Add value to reset counter
        resetCount = 0;
    }
    else {
        resetCount ++; // Add value to reset counter
        LED.write(0);
        
    }
    if (sound < 5 && delayCount > 0 && resetCount > 9){ // Delay reset activates and prints the delay value
        oledcs.write(0);
        ThisThread::sleep_for(2ms);  // > minimum clock cycle time of 150ns for SSD1331
        
        OLED.clearScreen();
        OLED.setCursor(0,0);
        OLED.printf("Delay: %d\n", delayCount);
        ThisThread::sleep_for(1000ms);
        oledcs.write(1);
        
        delayCount = 0; // Resetting the variables
        sound = 0;
        raw = 0;
        resetCount = 0;
    }
    
    
}
