/*
* Автор - Железняков Андрей
* Сайт - itworkclub.ru
* Данный класс описывает энкодер с кнопкой KY-040
* Обработка вращения и нажатий происходит с помощью прерываний.
* При вращении энкодера меняется состояние переменной State
* в ту или иную сторону. Значения переменной State ограничены заданным
* диапазоном, например, от 0 до 100 или 0т 300 до 500. Диапазон задается
* функцией setRange. По умолчанию диапазон от 0 до 100.
* Узнать текущее значение энкодера можно с помощью функции getState();
* Нажата ли кнопка с помощью функции getButtonState();
* К энкодеру припаяны два дополнительных конденсатора по 1000пФ для устранения
* дребезга: один между GND и CLK, второй между GND и DT. Если этих конденсаторов
* нет, то необходимо раскомментировать задержку в функции encode. Так же 
* необохдимо проверить запаян ли подтягивающий резистор 10кОм на кнопку SW
* Его необходимо припаять.
*/

#ifndef Encoder_H
#define Encoder_H


#include "mbed.h"

class EncoderAli
{
    public:
        // В конструкторе задаем пины, к которым подключен энкодер   
        EncoderAli(PinName DT,PinName CLK1,PinName SW);
        
        int getState(); // возвращает положение энкодера 
        void setRange(int minValue,int maxValue);// задает диапазон 
        bool getButtonState();// true - кнопка нажата, false - отжата
    private:
        
        int State; // положение энкодера
        bool work; // флаг, который поднимается, когда идет обработка прерывания
                   // и опускается по заверщении прерывания.  
        int minValue_; // минимальное значение энкодера
        int maxValue_; // максимальное значение энкодера
        bool button;   //true - кнопка нажата, false - отжата
        
        DigitalIn DT_;
        InterruptIn CLK1_;
        InterruptIn SW_;
        
        void encode(void); //обработчик вызывается при повороте энкодера
        void buttonPress(void); //обработчик вызывается при нажатии кнопки
        void buttonUp(void); // обработчик вызывается при отпускании кнопки
            
};

#endif