/*
* Автор - Железняков Андрей
* Сайт - itworkclub.ru
* Данный класс описывает энкодер с кнопкой KY-040
* Обработка вращения и нажатий происходит с помощью прерываний.
* При вращении энкодера меняется состояние переменной State
* в ту или иную сторону. Значения переменной State ограничены заданным
* диапазоном, например, от 0 до 100 или 0т 300 до 500. Диапазон задается
* функцией setRange. По умолчанию диапазон от 0 до 100.
* Узнать текущее значение энкодера можно с помощью функции getState();
* Нажата ли кнопка с помощью функции getButtonState();
* К энкодеру припаяны два дополнительных конденсатора по 1000пФ для устранения
* дребезга: один между GND и CLK, второй между GND и DT. Если этих конденсаторов
* нет, то необходимо раскомментировать задержку в функции encode. Так же 
* необохдимо проверить запаян ли подтягивающий резистор 10кОм на кнопку SW
* Его необходимо припаять.
*/
#include "Encoder.h"

EncoderAli::EncoderAli(PinName DT,PinName CLK,PinName SW): DT_(DT), CLK1_(CLK), SW_(SW){
    
    // инициализация начального состояния энкодера
    work = false;
    minValue_ =0;
    maxValue_ = 100;
    button = false;
    State = minValue_;
    
    // подключение прерываний для вращения, нажатия и отжатия
    CLK1_.rise(callback(this,&EncoderAli::encode));
    SW_.fall(callback(this,&EncoderAli::buttonPress));
    SW_.rise(callback(this,&EncoderAli::buttonUp));
    
}


void EncoderAli::encode(void) // обработчик вращения
{
    if (work) return; // если идет обработка предыдущего прерывания то ничего 
                      // не делаем
    work = true;      // поднимаем флаг работы прерывания, тем самым запрещая
                      // выполнения других таких же прерываний
    int A = DT_;      // считываем значение пина DT
    //wait_us(100);
    if(A==0 && State < maxValue_) //если DT 0, то энкодер крутится вправо 
        State++;// увеличиваем значение состояния энкодера
    if (A==1 && State > minValue_) //если DT = 1, то энкодер крутится влево
        State--; // уменьшаем значение энкодера
    work = false; // освобождаем флаг работы прерывания
    

}
int EncoderAli::getState()
{
    return State; 
}
void EncoderAli::setRange(int minValue,int maxValue)
{
    minValue_=minValue;
    maxValue_=maxValue;
    State = minValue_;
}
void EncoderAli::buttonPress(void)
{
    button = true;
}
void EncoderAli::buttonUp(void)
{
    button = false;
}
bool EncoderAli::getButtonState()
{
    return button;   
}

