#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"
#include <stdio.h>
#include <string.h>
 
#define HTTPD_SERVER_PORT   80
#define HTTPD_MAX_REQ_LENGTH   1023
#define HTTPD_MAX_HDR_LENGTH   255
 
Serial uart(USBTX, USBRX);
 
EthernetInterface eth;
TCPSocketServer server;
TCPSocketConnection client;
 
char buffer[HTTPD_MAX_REQ_LENGTH+1];
char httpHeader[HTTPD_MAX_HDR_LENGTH+1];
 
char *uristr;
char *eou;
char *qrystr;
 
int r_on=0, g_on=0, b_on=0, relay1_on=0;
int r_col=0, g_col=0, b_col=0, relay1_col=0, s2_col=80, s3_col=80;
 
void display_page(void){
 
    sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
    client.send(httpHeader,strlen(httpHeader));
    sprintf(httpHeader,"<html>\r\n\t<head>\r\n\t\t<title>K64F HTTP RGB controller</title>\r\n\t\t<meta http-equiv='refresh' content='5'>\r\n\t</head>\r\n\t<body>\r\n\t\t<h1>K64F RGB on-line controller</h1>");
    client.send(httpHeader,strlen(httpHeader));
    sprintf(httpHeader,"\r\n\t\t<table cellspacing='5px'>\r\n\t\t\t<tr>\r\n\t\t\t\t<th colspan='2'>RGB controls & status</th>\r\n\t\t\t\t<th>SW2 status</th>\r\n\t\t\t\t<th>SW3 status</th>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td><form action='' method='post'>");
    client.send(httpHeader,strlen(httpHeader));
    
    sprintf(httpHeader,"\r\n\t\t\t\t\t<label for='R'>R:\t</label><input type='checkbox' name='R' id='R'");
    if(r_on)
        strcat(httpHeader, " checked='checked'><br>");
    else
        strcat(httpHeader, "><br>");
    client.send(httpHeader,strlen(httpHeader));
    
    sprintf(httpHeader,"\r\n\t\t\t\t\t<label for='G'>G:\t</label><input type='checkbox' name='G' id='G'");
    if(g_on)
        strcat(httpHeader, " checked='checked'><br>");
    else
        strcat(httpHeader, "><br>");
    client.send(httpHeader,strlen(httpHeader));
    
    sprintf(httpHeader,"\r\n\t\t\t\t\t<label for='relay1'>relay1:\t</label><input type='checkbox' name='relay1' id='relay1'");
    if(relay1_on)
        strcat(httpHeader, " checked='checked'><br>");
    else
        strcat(httpHeader, "><br>");
    client.send(httpHeader,strlen(httpHeader));
    
    sprintf(httpHeader,"\r\n\t\t\t\t\t<label for='B'>B:\t</label><input type='checkbox' name='B' id='B'");
    if(b_on)
        strcat(httpHeader, " checked='checked'><br>");
    else
        strcat(httpHeader, "><br>");
    client.send(httpHeader,strlen(httpHeader));
    
    sprintf(httpHeader,"\r\n\t\t\t\t\t<input type='submit' value='Save'>\r\n\t\t\t\t</form></td>");
    client.send(httpHeader,strlen(httpHeader));       
    sprintf(httpHeader,"\r\n\t\t\t\t<td style='vertical-align: bottom;'><div style='background: #%02x%02x%02x; width: 80px; height: 95%; border: 2px solid;'></div></td>",r_col, g_col, b_col);
    client.send(httpHeader,strlen(httpHeader));
        sprintf(httpHeader,"\r\n\t\t\t\t<td style='vertical-align: bottom;'><div style='background: #%02x; width: 80px; height: 95%; border: 2px solid;'></div></td>", relay1_col);
    client.send(httpHeader,strlen(httpHeader));
    sprintf(httpHeader,"\r\n\t\t\t\t<td style='vertical-align: bottom;'><div style='background: black; width: 84px; height: %dpx;'></div></td>",s2_col);
    client.send(httpHeader,strlen(httpHeader));
    sprintf(httpHeader,"\r\n\t\t\t\t<td style='vertical-align: bottom;'><div style='background: black; width: 84px; height: %dpx;'></div></td>",s3_col);
    client.send(httpHeader,strlen(httpHeader));
    sprintf(httpHeader,"\r\n\t\t\t</tr>\r\n\t\t</table>\r\n\t</body>\r\n</html>");
    client.send(httpHeader,strlen(httpHeader));
 
}
 
int main (void)
{
//    RGB LED outputs
    DigitalOut  rled(LED_RED, 1);
    DigitalOut  gled(LED_GREEN, 1);
    DigitalOut  bled(LED_BLUE, 1);
    
//    Relay outputs

    DigitalOut d0(PTC16);
 
//    SW2 & SW3 inputs
    DigitalIn   sw2(PTC6);
    DigitalIn   sw3(PTA4);
 
//    Serial Interface eth;
    uart.baud(115200);
    uart.printf("Initializing\n");
 
//    EthernetInterface eth;
    uart.printf("Initializing Ethernet\n");
    eth.init(); //Use DHCP
    uart.printf("Connecting\n");
    eth.connect();
    uart.printf("IP Address is %s\n", eth.getIPAddress());
 
//    TCPSocketServer server;
    server.bind(HTTPD_SERVER_PORT);
    server.listen();
    uart.printf("Server Listening\n");
 
    while (true) {
        uart.printf("\nWaiting for new connection...\r\n");
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s
 
        if(r_on){           //zadost o rozsviceni cervene LED
            rled=0;         //led aktivni logickou 0
        }
        else{
            rled=1;
        }
 
        if(g_on){           //zadost o rozsviceni zelene LED
            gled=0;         //led aktivni logickou 0
        }
        else{
            gled=1;
        }
 
        if(b_on){           //zadost o rozsviceni modre LED
            bled=0;         //led aktivni logickou 0
        }
        else{
            bled=1;
        }
        
        if(relay1_on){           //zadost o zapnutie relay1
            d0=0;         //relay aktivni logickou 0
        }
        else{
            d0=1;
        }
        
       
 
        if(sw2){            //nacteni stavu tlacitka SW2
            s2_col = 70;    //pokud neni tlacitko zmacknute zobrazi se vysoky sloupecek
        }
        else{
            s2_col = 30;    //pokud je tlacitko zmacknute zobrazi se nizky sloupecek
        }
        if(sw3){
            s3_col = 70;
        }
        else{  
            s3_col = 30;  
        }
 
 
        uart.printf("Connection from: %s\r\n", client.get_address());
        while (true) {
 
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            uart.printf("Recieved Data: %d\r\n\r\n%.*s\r\n",n,n,buffer);
            if (n >= 1024) {
                sprintf(httpHeader,"HTTP/1.1 413 Request Entity Too Large \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                client.send(httpHeader,strlen(httpHeader));
                client.send(buffer,n);
                break;
            } else {
                buffer[n]=0;
            }
 
            if(!strstr(buffer, "Authorization: Basic TVBPQToyMDE0")){        //MPOA 2014
                sprintf(httpHeader,"HTTP/1.1 401 Authorization Required \r\nContent-Type: text\r\nWWW-Authenticate: Basic realm='Login required!'\r\n\r\n");
                client.send(httpHeader,strlen(httpHeader));
                sprintf(httpHeader, "<HTML>\r\n\t<HEAD>\r\n\t\t<TITLE>Error</TITLE>\r\n\t</HEAD>\r\n\t<BODY>\r\n\t\t<H1>401 Unauthorised.</H1>\r\n\t</BODY>\r\n</HTML>");
                client.send(httpHeader,strlen(httpHeader));
                client.close();
            }
 
                if (!strncmp(buffer, "GET ", 4)) {
                    uristr = buffer + 4;
                    eou = strstr(uristr, " ");
                    if (eou == NULL) {
                        sprintf(httpHeader,"HTTP/1.1 400 Bad Request \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                        client.send(httpHeader,strlen(httpHeader));
                        client.send(buffer,n);
                    } 
                    else {
                        *eou = 0;                                                
                        display_page();
                        client.close();
                    }
                }                
                else if (!strncmp(buffer, "POST ", 5)) {
 
                    int n = client.receive(buffer, sizeof(buffer));
 
                    if (strstr(buffer, "R=on")) {
                        r_on = 1;
                        r_col = 255;
                    }
                    else{
                        r_on = 0;
                        r_col = 0;
                    }
                    if (strstr(buffer, "G=on")) {
                        g_on = 1;
                        g_col = 255;
                    }
                    else{
                        g_on = 0;
                        g_col = 0;
                    }
                    if (strstr(buffer, "B=on")) {
                        b_on = 1;
                        b_col = 255;
                    }
                    if (strstr(buffer, "relay1=on")) {
                        relay1_on = 1;
                        relay1_col = 255;
                    }
                    else{
                        b_on = 0;
                        b_col = 0;
                    }
 
                    display_page();
                    client.close();
                }           
            }
            client.close();   
    }
}