#include "mbed.h"
#include "EthernetInterface.h"

char* thingSpeakUrl = "api.thingspeak.com";
char* thingSpeakKey = "KXD7399710CF3CIN";
float latitude = 26.9;

int main() {
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    
    for (float longitude = 70.90; longitude < 76.0; longitude = longitude + 0.50)
    {
    TCPSocketConnection sock;
    sock.connect(thingSpeakUrl , 80);
    char http_cmd[256];
    sprintf(http_cmd,"GET /update?key=%s&field1=%f&field2=%f HTTP/1.0\n\n",thingSpeakKey,latitude,longitude);
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    printf("sent url");
    
    char buffer[300];
    int ret;
    
    ret = sock.receive(buffer, sizeof(buffer)-1);
    buffer[ret] = '\0';
    printf("Received %d chars from server:\n%s\n", ret, buffer);
    
    wait(16);  // limited by ThingSpeak's API
    
      
    sock.close();
    }
    
    eth.disconnect();
    
    while(1) {}
}
