#include "mbed.h"
#include "UbloxUSBGSMModem.h"
#include "UbloxUSBCDMAModem.h"
#include "CellularModem.h"
#include "Socket.h"
#include "Endpoint.h"
#include "UDPSocket.h"
#include "C12832_lcd.h"
#include "nsdl_support.h"
// Include various resources
#include "temperature.h"
#include "light.h"
#include "gps.h"
#include "relay.h"

static C12832_LCD lcd;

// ****************************************************************************
// Handlers for debugging crashes

#include <rt_misc.h>
extern char Image$$RW_IRAM1$$ZI$$Limit[];

extern "C" void HardFault_Handler(void)
{
    uint32_t zi_limit = (uint32_t)Image$$RW_IRAM1$$ZI$$Limit;
    uint32_t sp_limit = __current_sp();
 
    zi_limit = (zi_limit + 7) & ~0x7;    // ensure zi_limit is 8-byte aligned
 
    struct __initial_stackheap r;
    r.heap_base = zi_limit;
    r.heap_limit = sp_limit;
    r=r;
    
    mbed_die();
    while(1);
}

extern "C" void MemManage_Handler(void)
{
    mbed_die();
    while(1);
}

extern "C" void BusFault_Handler(void)
{
    mbed_die();
    while(1);
}

extern "C" void UsageFault_Handler(void)
{
    mbed_die();
    while(1);
}

// ****************************************************************************
// Configuration section

#define MODEM_UBLOX_CDMA
//#define MODEM_UBLOX_GSM

#if !defined(MODEM_UBLOX_GSM) && !defined(MODEM_UBLOX_CDMA)
#warning No modem defined, using GSM by default
#define MODEM_UBLOX_GSM
#endif

#ifndef MODEM_APN
#warning APN not specified, using "internet"
#define MODEM_APN "internet"
#endif

#ifndef MODEM_USERNAME
#warning username not specified
#define MODEM_USERNAME NULL
#endif

#ifndef MODEM_PASSWORD
#warning password not specified
#define MODEM_PASSWORD NULL
#endif

// Ethernet configuration
/* Define this to enable DHCP, otherwise manual address configuration is used */
#define DHCP

/* Manual IP configurations, if DHCP not defined */
#define IP      "10.45.0.206"
#define MASK    "255.255.255.0"
#define GW      "10.45.0.1"

// NSP configuration
/* Change this IP address to that of your NanoService Platform installation */
static const char* NSP_ADDRESS = "217.140.101.20"; /* demo NSP, web interface at http://nanoservice-demo.mbed.org*/ 
static const int NSP_PORT = 5683;
char endpoint_name[16] = "mbed-";
uint8_t ep_type[] = {"mbed_device"};
uint8_t lifetime_ptr[] = {"1200"};

UDPSocket server;
Endpoint nsp;

// ****************************************************************************
// u-blox Cellular initialization
// needed for offline debugging to eliminate the semi-hosting calls
//extern "C" int mbed_interface_uid(char *uid)
//{
//    uid[27] = '1';
//    uid[28] = 'a';
//    uid[29] = '5';
//    uid[30] = 'b';
//    uid[31] = '3';
//    uid[32] = '\0';
//    
//    return 1;
//}


static void cellular_init(CellularModem& modem, const char* apn = NULL, const char* username = NULL, const char* password= NULL)
{
    char mbed_uid[33]; // for creating unique name for the board

    modem.power(true);
    Thread::wait(1000);
    int ret = modem.connect(MODEM_APN, MODEM_USERNAME, MODEM_PASSWORD);
    if(ret)
    {
      printf("Could not connect\n");
    }
    printf("Connection OK\n");

    mbed_interface_uid(mbed_uid);
    mbed_uid[32] = '\0';
    strncat(endpoint_name, mbed_uid + 27, 15 - strlen(endpoint_name));
}


// ****************************************************************************
// NSP initialization

static void nsp_init()
{
    server.init();
    server.bind(NSP_PORT);

    nsp.set_address(NSP_ADDRESS, NSP_PORT);
    
    printf("name: %s", endpoint_name);
    printf("NSP=%s - port %d\n", NSP_ADDRESS, NSP_PORT);

    lcd.locate(0,22);
    lcd.printf("EP name:%s\n", endpoint_name);
}

// ****************************************************************************
// Resource creation

static int create_resources()
{
    sn_nsdl_resource_info_s *resource_ptr = NULL;
    sn_nsdl_ep_parameters_s *endpoint_ptr = NULL;
    
    printf("Creating resources");

    /* Create resources */
    resource_ptr = (sn_nsdl_resource_info_s*)nsdl_alloc(sizeof(sn_nsdl_resource_info_s));
    if(!resource_ptr)
        return 0;
    memset(resource_ptr, 0, sizeof(sn_nsdl_resource_info_s));

    resource_ptr->resource_parameters_ptr = (sn_nsdl_resource_parameters_s*)nsdl_alloc(sizeof(sn_nsdl_resource_parameters_s));
    if(!resource_ptr->resource_parameters_ptr)
    {
        nsdl_free(resource_ptr);
        return 0;
    }
    memset(resource_ptr->resource_parameters_ptr, 0, sizeof(sn_nsdl_resource_parameters_s));

    // Static resources
    nsdl_create_static_resource(resource_ptr, sizeof("dev/mfg")-1, (uint8_t*) "dev/mfg", 0, 0,  (uint8_t*) "Sensinode", sizeof("Sensinode")-1);
    nsdl_create_static_resource(resource_ptr, sizeof("dev/mdl")-1, (uint8_t*) "dev/mdl", 0, 0,  (uint8_t*) "NSDL-C mbed device", sizeof("NSDL-C mbed device")-1);

    // Dynamic resources
    create_temperature_resource(resource_ptr);
    create_light_resource(resource_ptr);
    create_gps_resource(resource_ptr);
    create_relay_resource(resource_ptr);

        /* Register with NSP */
    endpoint_ptr = nsdl_init_register_endpoint(endpoint_ptr, (uint8_t*)endpoint_name, ep_type, lifetime_ptr);
    if(sn_nsdl_register_endpoint(endpoint_ptr) != 0)
        printf("NSP registering failed\r\n");
    else
        printf("NSP registering OK\r\n");
    nsdl_clean_register_endpoint(&endpoint_ptr);

    nsdl_free(resource_ptr->resource_parameters_ptr);
    nsdl_free(resource_ptr);
    return 1;
}

// running led
Ticker flash;
DigitalOut led(LED1);
void flashLED(void){led = !led;}

// ****************************************************************************
// Program entry point

int main()
{
    flash.attach(&flashLED, 1.0f);
    
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("mbed NanoService u-blox");
    printf("mbed NanoService u-blox Example App 0.1\n");
    
#ifdef MODEM_UBLOX_GSM
    UbloxUSBGSMModem modem;
#else
    UbloxUSBCDMAModem modem(p18, true, 1);
#endif
    
    // Initialize Cellular interface first
    puts("cellular_init");
    cellular_init(modem);
    
    // Initialize NSP node
    puts("nsp_init");
    nsp_init();
    
    // Initialize NSDL stack
    puts("nsdl_init");
    nsdl_init();
    
    // Create NSDL resources
    puts("create_resources");
    create_resources();
    
    // Run the NSDL event loop (never returns)
    puts("nsdl_event_loop");
    nsdl_event_loop();
}
