#ifndef DEBUG_H
#define DEBUG_H

#include "mbed.h"

// Set the debugging level, 0 = off, 1 = simple, 2 = detailed
#define DEBUG_LEVEL 1

#if (DEBUG_LEVEL) == 2
#define DEBUG(x, ...) printf("[DEBUG: %s:%d] " x "\r\n", __FILE__, __LINE__, ##__VA_ARGS__);
#define WARNING(x, ...) printf("[WARNING: %s:%d] " x "\r\n", __FILE__, __LINE__, ##__VA_ARGS__);
#define ERROR(x, ...) printf("[ERROR: %s:%d] " x "\r\n", __FILE__, __LINE__, ##__VA_ARGS__);
#elif (DEBUG_LEVEL) == 1
#define DEBUG(x, ...) printf("[DEBUG] " x "\r\n", ##__VA_ARGS__);
#define WARNING(x, ...) printf("[WARNING] " x "\r\n", ##__VA_ARGS__);
#define ERROR(x, ...) printf("[ERROR] " x "\r\n", ##__VA_ARGS__);
#elif (DEBUG_LEVEL) == 0
#define DEBUG(x, ...)
#define WARNING(x, ...)
#define ERROR(x, ...)
#endif

#endif // DEBUG_H