#include "mbed.h"
#include "MMA8451Q.h"
////////////////////definicie pre freefall//////////////
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
  PinName const SDA = PTB1;
  PinName const SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)
///////////////////////////////////////////////////////

////////////////////definicie adries////////////////////
#define INF_DISPLAY     0x30
#define TERMINAL     0x0D

#define CAB_BUT_P     0xb0
#define CAB_BUT_1     0xb1
#define CAB_BUT_2    0xb2
#define CAB_BUT_3     0xb3
#define CAB_BUT_4     0xb4

#define CAB_DIODE_P     0x20
#define CAB_DIODE_1    0x21
#define CAB_DIODE_2     0x22
#define CAB_DIODE_3     0x23
#define CAB_DIODE_4     0x24

#define ELEVATOR     0xf0

#define FLOOR_BUT_4    0xc4
#define FLOOR_BUT_3     0xc3
#define FLOOR_BUT_2     0xc2
#define FLOOR_BUT_1     0xc1
#define FLOOR_BUT_P     0xc0

#define FLOOR_DIODE_4     0x14
#define FLOOR_DIODE_3     0x13
#define FLOOR_DIODE_2    0x12
#define FLOOR_DIODE_1    0x11
#define FLOOR_DIODE_P     0x10

#define FLOOR_LIMIT_SWITCH_4     0xe4
#define FLOOR_LIMIT_SWITCH_3     0xe3
#define FLOOR_LIMIT_SWITCH_2     0xe2
#define FLOOR_LIMIT_SWITCH_1     0xe1
#define FLOOR_LIMIT_SWITCH_P     0xe0

#define WATCHDOG_TIMER     0xfe
#define MOTOR     0xf1
#define EMERGENCY_BREAK  0xf
#define MOJA_ADRESA    0xAA
//////////////////////////////////////////////////

////////////////globalne premenne//////////////////
InterruptIn intin(PTA15);//Interupt pre freefall
MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);//accelerometer
Serial pc(USBTX, USBRX,57600);
char crc=0x00;//pre vypocet crc
char cesta[5]={'x','x','x','x','x'};//pole na ulozenie poziadaviek
int aktpozicia=4;//aktualna pozicia vytahu
char smerpohybu=0x03;//smer pohybu vytahu
unsigned char kruhovybuffer[200];//obsahuje prijate znaky
int indexcitania=0;//urcuje index nacitavania z kruhoveho buferu
Timer timer;
Ticker ticker;
int indexzapisu=0;
char ccc[256]={0, 94, 188, 226, 97, 63, 221, 131, 194, 156, 126, 32, 163, 253, 31, 65,
    157, 195, 33, 127, 252, 162, 64, 30, 95, 1, 227, 189, 62, 96, 130, 220,
    35, 125, 159, 193, 66, 28, 254, 160, 225, 191, 93, 3, 128, 222, 60, 98,
    190, 224, 2, 92, 223, 129, 99, 61, 124, 34, 192, 158, 29, 67, 161, 255,
    70, 24, 250, 164, 39, 121, 155, 197, 132, 218, 56, 102, 229, 187, 89, 7,
    219, 133, 103, 57, 186, 228, 6, 88, 25, 71, 165, 251, 120, 38, 196, 154,
    101, 59, 217, 135, 4, 90, 184, 230, 167, 249, 27, 69, 198, 152, 122, 36,
    248, 166, 68, 26, 153, 199, 37, 123, 58, 100, 134, 216, 91, 5, 231, 185,
    140, 210, 48, 110, 237, 179, 81, 15, 78, 16, 242, 172, 47, 113, 147, 205,
    17, 79, 173, 243, 112, 46, 204, 146, 211, 141, 111, 49, 178, 236, 14, 80,
    175, 241, 19, 77, 206, 144, 114, 44, 109, 51, 209, 143, 12, 82, 176, 238,
    50, 108, 142, 208, 83, 13, 239, 177, 240, 174, 76, 18, 145, 207, 45, 115,
    202, 148, 118, 40, 171, 245, 23, 73, 8, 86, 180, 234, 105, 55, 213, 139,
    87, 9, 235, 181, 54, 104, 138, 212, 149, 203, 41, 119, 244, 170, 72, 22,
    233, 183, 85, 11, 136, 214, 52, 106, 43, 117, 151, 201, 74, 20, 246, 168,
    116, 42, 200, 150, 21, 75, 169, 247, 182, 232, 10, 84, 215, 137, 107, 53};

///////prototypy funkcii////////////////////////
void spustiVytah(int nasledujucePoschodie);
void zobrazPoschodie(char poschodie);
void zamkniVytah();
void odomkniVytah();
void zastavVytah();
void zasvietDiodu(char ktoru);
void zhasniDiodu(char ktoru);
void watchdogReset();
void odstranPotvrdenia();
///////////////////////////////////////////////

//////////////////////prerusenie vyvolane pri freefall///////
void intfun(){

        uint8_t datan[1]; 
acc.readRegs(0x0C,datan,1);//precitam register z akcelerometra
if((datan[0]&0x04)==0x04){//ak je prerusenie pre freefall 
    acc.readRegs(0x16,datan,1);//precitanim registra rusim poziadavku o prerusenie
         timer.start();
         int begin=timer.read();
         while((timer.read()-begin)<=5){
            char stopVytah[6];
        stopVytah[0]=0xA0;
        stopVytah[1]=EMERGENCY_BREAK;
        stopVytah[2]=MOJA_ADRESA;
        stopVytah[3]=0x01;
        stopVytah[4]=0x02;

        crc=0;
        crc=ccc[crc^stopVytah[1]];
        crc=ccc[crc^stopVytah[2]];
        crc=ccc[crc^stopVytah[4]];
        stopVytah[5]=crc;
        
        for(int p=0;p<=5;p++){
           while(pc.writable()==0){}
        pc.putc(stopVytah[p]);
        } 
        } 
    }
    }
////////////////////////////////////////////////////////

////////funkcia volana tickerom pre reset watchdogu////
void atTime(){
   watchdogReset();
    }
//////////////////////////////////////////////////////

///////funkcia prerusenia serioveho portu////
void funkcia(){
    kruhovybuffer[indexzapisu]=pc.getc();
    indexzapisu=indexzapisu+1;
    if(indexzapisu==200){
        indexzapisu=0;
        }
    }
/////////////////////////////////////////
int main(void)
{
     ///////////////////////nastavenie akcelerometra pre volny pad/////////////////////////////////////
    
    intin.fall(&intfun);//priradim preruseniu od akcelerometra funkciu intfun
   
    uint8_t krok1[2] = {0x2A, 0x20};
    acc.writeRegs(krok1, 2);
    
    uint8_t krok2[2] = {0x15, 0xB8};
    acc.writeRegs(krok2,2);
    
    uint8_t krok3[2] = {0x17, 0x03};
    acc.writeRegs(krok3,2);
    
    uint8_t krok4[2] = {0x18, 0x06};
    acc.writeRegs(krok4,2);
    
    uint8_t krok5[2] = {0x2D, 0x04};
    acc.writeRegs(krok5,2);
    
    uint8_t krok6[2] = {0x2E, 0x00};
    acc.writeRegs(krok6,2);
    
    
    //krok7
    uint8_t data[1]; 
    acc.readRegs(0x2A,data,1); 
    data[0]=data[0]| 0x01;
    
    uint8_t krok7[2] = {0x2A, data[0]};
    krok7[1] = data[0];
    acc.writeRegs(krok7,2);
    ////////////////////////////////////////////////////////////////////////////////////////////////////
   
   
    pc.attach(&funkcia,pc.RxIrq);//priradujem funkciu pre seriovy port, ktoru vykona pri vzniku prerusenia
   ticker.attach(&atTime,0.4); 
   char sprava[4];
    while (true) {
int dlzkanacitanych=0;

        odstranPotvrdenia(); //odstrani vsetky potvrdzovacie spravy z kruhoveho buffra

if(indexcitania<=indexzapisu){
    dlzkanacitanych=indexzapisu-indexcitania;
    }else{dlzkanacitanych=(200-indexcitania)+indexzapisu;}// v if else pocitam pocet prijatych dat
    
    
    
while(dlzkanacitanych>0&&kruhovybuffer[indexcitania]!=0xA0){
    
    indexcitania=(indexcitania+1)%200;
    
    
if(indexcitania<=indexzapisu){
    dlzkanacitanych=indexzapisu-indexcitania;
    }else{dlzkanacitanych=(200-indexcitania)+indexzapisu;}// v if else pocitam pocet prijatych dat
    
    }

    if(dlzkanacitanych>=5&&dlzkanacitanych>=5+kruhovybuffer[indexcitania+3]){  //pocet prijatych dat musi byt >=pocet dat spravy 
    
    //////////////////////////////////////ukladam do pola "sprava" a "zvysokspravy" casti spravy na jednotlive indexy//////////////////////////////////////
        sprava[0]=kruhovybuffer[indexcitania];//zaciatocny bajt 0xA0
        indexcitania=indexcitania+1;
        if(indexcitania==200){indexcitania=0;}

        sprava[1]=kruhovybuffer[indexcitania];//adresa prijimatela
        indexcitania=indexcitania+1;
        if(indexcitania==200){indexcitania=0;}

        sprava[2]=kruhovybuffer[indexcitania];//adresa odosielatela
        indexcitania=indexcitania+1;
        if(indexcitania==200){indexcitania=0;}

        sprava[3]=kruhovybuffer[indexcitania];//pocet dat
        indexcitania=indexcitania+1;
        if(indexcitania==200){indexcitania=0;}

    int dlzkazvysku=sprava[3]+1;
    char zvysokspravy[dlzkazvysku];//bude obsahovat data a crc
   
    for(int i=0;i<dlzkazvysku;i++){
            zvysokspravy[i]=kruhovybuffer[indexcitania];//pocet dat
            indexcitania=indexcitania+1;
            if(indexcitania==200){indexcitania=0;}   
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    //mam precitanu celu spravu
    
    
    if((sprava[2]&0xf0)==0xc0&&cesta[0]=='x'){//stlacene tlacidlo na poschodi a zaroven nie je ziadna poziadavka v poli cesta

        int naslpozicia;
        char adrDiodyPoschodia;
        
        
        if(sprava[2]==FLOOR_BUT_4){
        adrDiodyPoschodia=FLOOR_DIODE_4;
            cesta[0]='4';
                naslpozicia=4;    
        }else if(sprava[2]==FLOOR_BUT_3){
        adrDiodyPoschodia=FLOOR_DIODE_3;
            cesta[0]='3';
                naslpozicia=3;
        }else if(sprava[2]==FLOOR_BUT_2){
        adrDiodyPoschodia=FLOOR_DIODE_2;
            cesta[0]='2';
                naslpozicia=2;
        }else if(sprava[2]==FLOOR_BUT_1){
        adrDiodyPoschodia=FLOOR_DIODE_1;
            cesta[0]='1';
                naslpozicia=1;
        }else if(sprava[2]==FLOOR_BUT_P){
        adrDiodyPoschodia=FLOOR_DIODE_P;
            cesta[0]='P';
                naslpozicia=0;
        }
        
        if(aktpozicia==naslpozicia){
            cesta[0]='x';
        }else{///////////////ak poschodie kde je vytah privolany je ine ako to na ktorom aktualne vytah stoji
            
        ////////////////svietim diodu na poschodi//////////////////////////////////////////////////        
        
        zasvietDiodu(adrDiodyPoschodia);

        //////////////////////////////////////////////////////////////////////////////////////////
        
        /////////////////////spustam vytah//////////////////////////////////////////////////////
        spustiVytah(naslpozicia);
        //////////////////////////////////////////////////////////////////////////
        
        ///////////////////////////zamknem vytah/////////////////////////////////
        zamkniVytah();
        //////////////////////////////////////////////////////////////////////////
        
        ///////////////////////zobrazim poschodie//////////////////////////////////
        if(aktpozicia==4){
            zobrazPoschodie('4');
        }else if(aktpozicia==3){
            zobrazPoschodie('3');
        }else if(aktpozicia==2){
            zobrazPoschodie('2');
        }else if(aktpozicia==1){
            zobrazPoschodie('1');
        }else if(aktpozicia==0){
            zobrazPoschodie('P');
        }
     //////////////////////////////////////////////////////////////////////////////////
    }//aktpozicia!=naslpozicia
    
    }else if((sprava[2]&0xf0)==0xb0){//ak je kliknute na tlacidla z kabiny

        int poschodie;
        char znakposch;
        char adrDiodyKabiny;
        
        if(sprava[2]==CAB_BUT_4){
            poschodie=4;
                znakposch='4';
                    adrDiodyKabiny=CAB_DIODE_4;
        }else if(sprava[2]==CAB_BUT_3){
            poschodie=3;  
                znakposch='3';  
                    adrDiodyKabiny=CAB_DIODE_3;
        }else if(sprava[2]==CAB_BUT_2){
            poschodie=2;
                znakposch='2';
                    adrDiodyKabiny=CAB_DIODE_2;
        }else if(sprava[2]==CAB_BUT_1){
            poschodie=1;    
                znakposch='1';
                    adrDiodyKabiny=CAB_DIODE_1;
        }else if(sprava[2]==CAB_BUT_P){
            poschodie=0;    
                znakposch='P';
                    adrDiodyKabiny=CAB_DIODE_P;
        }
        
        if(aktpozicia!=poschodie){//svietim len ked je aktualna pozicia vytahu ina ako stlacena
        

        
        ////////ak je pole poziadaviek prazdne//////////
        int prazdne=0;
        if(cesta[0]=='x'&&cesta[1]=='x'&&cesta[2]=='x'&&cesta[3]=='x'&&cesta[4]=='x'){
            prazdne=1;
            }
        ///////////////////////////////////////////////
        
        
        /////////////////ulozim poziadavku do pola///////////////////////////////
        int uztamje=0;
        for(int t=0;t<5;t++){
            if(znakposch==cesta[t]){
                uztamje=1;
                }
            }
            
            if(uztamje==0){
                
        //////////////////////svietim diodu pri tlacidle/////////////////////

        zasvietDiodu(adrDiodyKabiny);
        
        ////////////////////////////////////////////////////////////////////////////////                
                
                for(int t=0;t<5;t++){
                 if(cesta[t]=='x'){
                    cesta[t]=znakposch;
                    break;
                 }
                }
            
            }
        //////////////////////////////////////////////////////////////////////////
        
        if(prazdne==1){ 
        ///////////////////////////zamknem vytah/////////////////////////////////
        
        zamkniVytah();

        //////////////////////////////////////////////////////////////////////////
            
                /////////////////////spustam vytah//////////////////////////////////////////////////////
          spustiVytah(poschodie);
        //////////////////////////////////////////////////////////////////////////    
            
                ///////////////////////zobrazim poschodie//////////////////////////////////
        if(aktpozicia==4){
        zobrazPoschodie('4');
        }else if(aktpozicia==3){
        zobrazPoschodie('3');
        }else if(aktpozicia==2){
        zobrazPoschodie('2');
        }else if(aktpozicia==1){
        zobrazPoschodie('1');
        }else if(aktpozicia==0){
        zobrazPoschodie('P');
        }
     //////////////////////////////////////////////////////////////////////////////////
            
            }// if prazdne==1
        
            
        
    }//if aktualnapozticia je ina ako stlacena
    } else if((sprava[2]&0xf0)==0xe0&&zvysokspravy[0]==0x01){// ak sprava od jedneho zo switchov a zaroven je vytah dalej 
        char kdesom;  
        if(sprava[2]==FLOOR_LIMIT_SWITCH_4){
        kdesom='4';
        }else if(sprava[2]==FLOOR_LIMIT_SWITCH_3){
        kdesom='3';
        }else if(sprava[2]==FLOOR_LIMIT_SWITCH_2){
        kdesom='2';
        }else if(sprava[2]==FLOOR_LIMIT_SWITCH_1){
        kdesom='1';
        }else if(sprava[2]==FLOOR_LIMIT_SWITCH_P){
        kdesom='P';
        }
        
        if(kdesom==cesta[0]){//ak som na poschodi kde chcem zastavit
        zastavVytah();
    }  
            } else if((sprava[2]&0xf0)==0xe0&&zvysokspravy[0]==0x02){//som blizko pri switchi, svieti na cerveno
        char kdesom;  
        if(sprava[2]==FLOOR_LIMIT_SWITCH_4){
        kdesom='4';
        }else if(sprava[2]==FLOOR_LIMIT_SWITCH_3){
        kdesom='3';
        }else if(sprava[2]==FLOOR_LIMIT_SWITCH_2){
        kdesom='2';
        }else if(sprava[2]==FLOOR_LIMIT_SWITCH_1){
        kdesom='1';
        }else if(sprava[2]==FLOOR_LIMIT_SWITCH_P){
        kdesom='P';
        }
        
        if(kdesom==cesta[0]){         
            ///////////////////////poposuvam poziadavky v poli//////////////////////////////
            cesta[0]=cesta[1];
            cesta[1]=cesta[2];
            cesta[2]=cesta[3];
            cesta[3]=cesta[4];
            cesta[4]='x';
            ////////////////////////////////////////////////////////////////////////////////
            
       ///////////////////////////////zhasnem diodu na poschodi////////////////////////////////  
        char adrDiodyPoschodia;
        
        if(kdesom=='4'){
        aktpozicia=4;    
        adrDiodyPoschodia=FLOOR_DIODE_4;
        }else if(kdesom=='3'){
        aktpozicia=3;    
        adrDiodyPoschodia=FLOOR_DIODE_3;
        }else if(kdesom=='2'){
        aktpozicia=2;    
        adrDiodyPoschodia=FLOOR_DIODE_2;
        }else if(kdesom=='1'){
        aktpozicia=1;    
        adrDiodyPoschodia=FLOOR_DIODE_1;
        }else if(kdesom=='P'){
        aktpozicia=0;    
        adrDiodyPoschodia=FLOOR_DIODE_P;
        }
        
        zhasniDiodu(adrDiodyPoschodia);

        ////////////////////////////////////////////////////////////////////////////////
        
        ///////////////////////zhasnem diodu vo vytahu//////////////////////////////////  
        
        char adrDiodyKabiny;
        if(kdesom=='4'){   
        adrDiodyKabiny=CAB_DIODE_4;
        }else if(kdesom=='3'){ 
        adrDiodyKabiny=CAB_DIODE_3;
        }else if(kdesom=='2'){
        adrDiodyKabiny=CAB_DIODE_2;
        }else if(kdesom=='1'){
        adrDiodyKabiny=CAB_DIODE_1;
        }else if(kdesom=='P'){
        adrDiodyKabiny=CAB_DIODE_P;
        }
        
        zhasniDiodu(adrDiodyKabiny);
        
        ///////////////////////////////////////////////////////////////////////////
        
   smerpohybu=0x03;
   ////////////////////odomknem vytah///////////////////////////////////////////////
       odomkniVytah();

        /////////////////////////////////////////////////////////////////////////
   
   /////////////////zobraz poschodie//////////////////////
              zobrazPoschodie(kdesom);
        ///////////////////////////////////////////////////
        
        if(cesta[0]!='x'){//ak existuje nasledujuca poziadavka
          //////////////////////////cakam 5 sekund///////////////////////////
          timer.start();
          while(timer.read()<=5){}
          timer.stop();
          timer.reset();
          ////////////////////////////////////////////////////////////////////
          
        ///////////////////////////zamknem vytah/////////////////////////////////
        
        zamkniVytah();

        //////////////////////////////////////////////////////////////////////////
            
        /////////////////////spustam vytah//////////////////////////////////////////////////////
        int poschodie;
        if(cesta[0]=='4'){poschodie=4;}
        else if(cesta[0]=='3'){poschodie=3;}
        else if(cesta[0]=='2'){poschodie=2;}
        else if(cesta[0]=='1'){poschodie=1;}
        else if(cesta[0]=='P'){poschodie=0;}
        
        spustiVytah(poschodie);
        //////////////////////////////////////////////////////////////////////////
           
        ///////////////////////zobrazim poschodie//////////////////////////////////
        zobrazPoschodie(kdesom);
        //////////////////////////////////////////////////////////////////////////////////
          
            
            }//ak je dalsia poziadavka
        
    }//ak je sprava od switchu na poschodi kde zastavujem
     else{
        zobrazPoschodie(kdesom);
         }
  }//posledny if
  }//ak je cela sprava 
 }//while 
}//koniec mainu
///////////////////////////////////////////nadefinovane funkcie//////////////////////////////////////////////////
void zasvietDiodu(char ktoru){
///////////vytvaram spravu na poslanie///////////////////////
        char zapnutieDiody[6];
        zapnutieDiody[0]=0xA0;
        zapnutieDiody[1]=ktoru;  
        zapnutieDiody[2]=MOJA_ADRESA;
        zapnutieDiody[3]=0x01;
        zapnutieDiody[4]=0x01;
        crc=0;
        crc=ccc[crc^zapnutieDiody[1]];
        crc=ccc[crc^zapnutieDiody[2]];
        crc=ccc[crc^zapnutieDiody[4]];
        zapnutieDiody[5]=crc;
///posielam spravu kym bude opakuj==1//////////
     int opakuj=1;
     while(opakuj==1){
        //odstranPotvrdenia();           
           /////////posielam spravu///////////     
        for(int p=0;p<=5;p++){
        pc.putc(zapnutieDiody[p]);
        }
        //////////////////////////////////////
        
        //////////////////kym ubehne cas zistujem ci sa niekde v poli prijatych znakov nenachadza potvrdenie
        timer.start();
        int pocetDat=0;
        int br;
        int milisecStart = timer.read_ms();
        while((timer.read_ms()-milisecStart)<100){//kym je ubehnuty cas mensi ako 100 milisekund
        br=0;

            if(indexcitania<=indexzapisu){
                pocetDat=indexzapisu-indexcitania;
            }else{
                pocetDat=(199-indexcitania+1)+indexzapisu;
            }
            if(pocetDat>=5){
        for(int i=0;i<pocetDat-4;i++){
            if(kruhovybuffer[(indexcitania+i)%200]==0xA0&&kruhovybuffer[(indexcitania+1+i)%200]==0x00&&kruhovybuffer[(indexcitania+2+i)%200]==0x00&&kruhovybuffer[(indexcitania+3+i)%200]==0x00&&kruhovybuffer[(indexcitania+4+i)%200]==0x00){
                if(i!=0){
                for(int j=i-1;j>=0;j--){//pojde od indexu kde sa potvrdzovacia sprava nasla az po index citania
                    int odkial=(indexcitania+j)%200;
                    int kam=(odkial+5)%200;
                    kruhovybuffer[kam]=kruhovybuffer[odkial];
                }
                }    
                indexcitania=(indexcitania+5)%200;
                br=1; 
                opakuj=0;
                break;  
            }
            }
        }
                    if(br==1){break;}
      
        }  
        timer.stop();
        timer.reset();
        }//while opakuj==1
    }
    
    
    void zastavVytah(){
char poleznakov[6];
        poleznakov[0]=0xA0;
        poleznakov[1]=MOTOR;
        poleznakov[2]=MOJA_ADRESA;
        poleznakov[3]=0x01;
        poleznakov[4]=0x1;
        crc=0;
        crc=ccc[crc^poleznakov[1]];
        crc=ccc[crc^poleznakov[2]];
        crc=ccc[crc^poleznakov[4]];
        poleznakov[5]=crc;
        
        
             int opakuj=1;
     while(opakuj==1){   
        //odstranPotvrdenia();          
        for(int p=0;p<=5;p++){
        pc.putc(poleznakov[p]);
        }
        //////////////////kym ubehne cas zistujem ci sa niekde v poli prijatych znakov nenachadza 
        timer.start();
        int milisecStart = timer.read_ms();
        int pocetDat=0;
        int br;
        while((timer.read_ms()-milisecStart)<100){//kym je ubehnuty cas mensi ako 100 milisekund
        br=0;
            if(indexcitania<=indexzapisu){
                pocetDat=indexzapisu-indexcitania;
            }else{
                pocetDat=(199-indexcitania+1)+indexzapisu;
            }
        for(int i=0;i<pocetDat-4;i++){
            if(kruhovybuffer[(indexcitania+i)%200]==0xA0&&kruhovybuffer[(indexcitania+1+i)%200]==0x00&&kruhovybuffer[(indexcitania+2+i)%200]==0x00&&kruhovybuffer[(indexcitania+3+i)%200]==0x00&&kruhovybuffer[(indexcitania+4+i)%200]==0x00){
                pc.putc(0xcc);                
                if(i!=0){
                for(int j=i-1;j>=0;j--){//pojde od indexu kde sa potvrdzovacia sprava nasla az po index citania
                    //if(j==-1){j=99;}
                    int odkial=(indexcitania+j)%200;
                    int kam=(odkial+5)%200;
                    kruhovybuffer[kam]=kruhovybuffer[odkial];
                }
                }   
                indexcitania=(indexcitania+5)%200;
                br=1; 
                opakuj=0;
                break;  
            }
            
        }
                    if(br==1){break;}
      
        }  
        timer.stop();
        timer.reset();
        }//while opakuj==1
    }
    
    
    
void zhasniDiodu(char ktoru){

        char vypnutiediodyvnutri[6];
        vypnutiediodyvnutri[0]=0xA0;
        vypnutiediodyvnutri[1]=ktoru;
        vypnutiediodyvnutri[2]=MOJA_ADRESA;
        vypnutiediodyvnutri[3]=0x01;
        vypnutiediodyvnutri[4]=0x00;
        crc=0;
        crc=ccc[crc^vypnutiediodyvnutri[1]];
        crc=ccc[crc^vypnutiediodyvnutri[2]];
        crc=ccc[crc^vypnutiediodyvnutri[4]];
        vypnutiediodyvnutri[5]=crc;
            
             int opakuj=1;
     while(opakuj==1){   
        //odstranPotvrdenia();          
        for(int p=0;p<=5;p++){
        pc.putc(vypnutiediodyvnutri[p]);
        }
        //////////////////kym ubehne cas zistujem ci sa niekde v poli prijatych znakov nenachadza 
        timer.start();
        int milisecStart = timer.read_ms();

        int br;
        while((timer.read_ms()-milisecStart)<100){//kym je ubehnuty cas mensi ako 100 milisekund
        br=0;
                int pocetDat=0;
            if(indexcitania<=indexzapisu){
                pocetDat=indexzapisu-indexcitania;
            }else{
                pocetDat=(199-indexcitania+1)+indexzapisu;
            }
        for(int i=0;i<pocetDat-4;i++){
            if(kruhovybuffer[(indexcitania+i)%200]==0xA0&&kruhovybuffer[(indexcitania+1+i)%200]==0x00&&kruhovybuffer[(indexcitania+2+i)%200]==0x00&&kruhovybuffer[(indexcitania+3+i)%200]==0x00&&kruhovybuffer[(indexcitania+4+i)%200]==0x00){
                pc.putc(0xcc);                
                if(i!=0){
                for(int j=i-1;j>=0;j--){//pojde od indexu kde sa potvrdzovacia sprava nasla az po index citania
                    int odkial=(indexcitania+j)%200;
                    int kam=(odkial+5)%200;
                    kruhovybuffer[kam]=kruhovybuffer[odkial];
                }
                }   
                indexcitania=(indexcitania+5)%200;
                br=1; 
                opakuj=0;
                break;  
            }
            
        }
                    if(br==1){break;}
      
        }  
        timer.stop();
        timer.reset();
        }//while opakuj==1
    }

void zamkniVytah(){

    char zamkni[6];
        zamkni[0]=0xA0;
        zamkni[1]=ELEVATOR;        
        zamkni[2]=MOJA_ADRESA;
        zamkni[3]=0x01;
        zamkni[4]=0x01;
        
        crc=0;
        crc=ccc[crc^zamkni[1]];
        crc=ccc[crc^zamkni[2]];
        crc=ccc[crc^zamkni[4]];
        
        zamkni[5]=crc;
        
                 int opakuj=1;
     while(opakuj==1){
        //odstranPotvrdenia();        
        for(int p=0;p<=5;p++){
        pc.putc(zamkni[p]);
        }
        //////////////////kym ubehne cas zistujem ci sa niekde v poli prijatych znakov nenachadza 
        timer.start();
        int milisecStart = timer.read_ms();

        int br;
        while((timer.read_ms()-milisecStart)<100){//kym je ubehnuty cas mensi ako 100 milisekund
        br=0;
                int pocetDat=0;
            if(indexcitania<=indexzapisu){
                pocetDat=indexzapisu-indexcitania;
            }else{
                pocetDat=(199-indexcitania+1)+indexzapisu;
            }
        for(int i=0;i<pocetDat-4;i++){
            if(kruhovybuffer[(indexcitania+i)%200]==0xA0&&kruhovybuffer[(indexcitania+1+i)%200]==0x00&&kruhovybuffer[(indexcitania+2+i)%200]==0x00&&kruhovybuffer[(indexcitania+3+i)%200]==0x00&&kruhovybuffer[(indexcitania+4+i)%200]==0x00){
                pc.putc(0xcc);                
                if(i!=0){
                for(int j=/*((indexcitania+i)%100)-1*/i-1;j>=/*indexcitania*/0;j--){//pojde od indexu kde sa potvrdzovacia sprava nasla az po index citania
                    //if(j==-1){j=99;}
                    int odkial=(indexcitania+j)%200;
                    int kam=(odkial+5)%200;
                    kruhovybuffer[kam]=kruhovybuffer[odkial];
                }
                }    
                indexcitania=(indexcitania+5)%200;
                br=1; 
                opakuj=0;
                break;  
            }
            
        }
                    if(br==1){break;}
      
        }  
        timer.stop();
        timer.reset();
        }//while opakuj==1
    }

void odomkniVytah(){

    char odomkni[6];
        odomkni[0]=0xA0;
        odomkni[1]=ELEVATOR;        
        odomkni[2]=MOJA_ADRESA;
        odomkni[3]=0x01;
        odomkni[4]=0x00;
        
        crc=0;
        crc=ccc[crc^odomkni[1]];
        crc=ccc[crc^odomkni[2]];
        crc=ccc[crc^odomkni[4]];
        
        odomkni[5]=crc;
        
                 int opakuj=1;
     while(opakuj==1){
        //odstranPotvrdenia();        
        for(int p=0;p<=5;p++){
        pc.putc(odomkni[p]);
        }
        //////////////////kym ubehne cas zistujem ci sa niekde v poli prijatych znakov nenachadza 
        timer.start();
        int milisecStart = timer.read_ms();
        int pocetDat=0;
        int br;
        while((timer.read_ms()-milisecStart)<100){//kym je ubehnuty cas mensi ako 100 milisekund
        br=0;
            if(indexcitania<=indexzapisu){
                pocetDat=indexzapisu-indexcitania;
            }else{
                pocetDat=(199-indexcitania+1)+indexzapisu;
            }
        for(int i=0;i<pocetDat-4;i++){
            if(kruhovybuffer[(indexcitania+i)%200]==0xA0&&kruhovybuffer[(indexcitania+1+i)%200]==0x00&&kruhovybuffer[(indexcitania+2+i)%200]==0x00&&kruhovybuffer[(indexcitania+3+i)%200]==0x00&&kruhovybuffer[(indexcitania+4+i)%200]==0x00){
                pc.putc(0xcc);                
                if(i!=0){
                for(int j=i-1;j>=0;j--){//pojde od indexu kde sa potvrdzovacia sprava nasla az po index citania
                    int odkial=(indexcitania+j)%200;
                    int kam=(odkial+5)%200;
                    kruhovybuffer[kam]=kruhovybuffer[odkial];
                }
                }     
                indexcitania=(indexcitania+5)%200;
                br=1; 
                opakuj=0;
                break;  
            }
            
        }      
                    if(br==1){break;}

        }  
        timer.stop();
        timer.reset();
        }//while opakuj==1
    }

void zobrazPoschodie(char poschodie){

    char infooposchodi[7];
        infooposchodi[0]=0xA0;
        infooposchodi[1]=INF_DISPLAY;
        infooposchodi[2]=MOJA_ADRESA;
        infooposchodi[3]=0x02;
        infooposchodi[4]=smerpohybu;
        infooposchodi[5]=poschodie;

        crc=0;
        crc=ccc[crc^infooposchodi[1]];
        crc=ccc[crc^infooposchodi[2]];
        crc=ccc[crc^infooposchodi[4]];
        crc=ccc[crc^infooposchodi[5]];
        infooposchodi[6]=crc;
        
             int opakuj=1;
     while(opakuj==1){
        //odstranPotvrdenia();        
        for(int p=0;p<=6;p++){
            while(pc.writable()==0){}
        pc.putc(infooposchodi[p]);
        }
        //////////////////kym ubehne cas zistujem ci sa niekde v poli prijatych znakov nenachadza 
        timer.start();
        int milisecStart = timer.read_ms();

        int br;
        while((timer.read_ms()-milisecStart)<100){//kym je ubehnuty cas mensi ako 100 milisekund
        br=0;
                int pocetDat=0;
            if(indexcitania<=indexzapisu){
                pocetDat=indexzapisu-indexcitania;
            }else{
                pocetDat=(199-indexcitania+1)+indexzapisu;
            }
        for(int i=0;i<pocetDat-4;i++){
            if(kruhovybuffer[(indexcitania+i)%200]==0xA0&&kruhovybuffer[(indexcitania+1+i)%200]==0x00&&kruhovybuffer[(indexcitania+2+i)%200]==0x00&&kruhovybuffer[(indexcitania+3+i)%200]==0x00&&kruhovybuffer[(indexcitania+4+i)%200]==0x00){
                pc.putc(0xcc);                
                if(i!=0){
                for(int j=i-1;j>=0;j--){//pojde od indexu kde sa potvrdzovacia sprava nasla az po index citania
                    int odkial=(indexcitania+j)%200;
                    int kam=(odkial+5)%200;
                    kruhovybuffer[kam]=kruhovybuffer[odkial];
                }
                }    
                indexcitania=(indexcitania+5)%200;
                br=1; 
                opakuj=0;
                break;  
            }
            
        }   
                    if(br==1){break;}
   
        }  
        timer.stop();
        timer.reset();
        }//while opakuj==1
    }

void spustiVytah(int nasledujucePoschodie){

     char spravamotoru[10];
             if(aktpozicia>nasledujucePoschodie){
                spravamotoru[5]=0x9c;
                spravamotoru[6]=0xff;
                spravamotoru[7]=0xff;
                spravamotoru[8]=0xff;
                smerpohybu=0x02;
             }else if(aktpozicia<nasledujucePoschodie){
                spravamotoru[5]=0x64;
                spravamotoru[6]=0x00;
                spravamotoru[7]=0x00;
                spravamotoru[8]=0x00;
                smerpohybu=0x01;
                }
    //pustam motor
        spravamotoru[0]=0xA0;
        spravamotoru[1]=MOTOR;        
        spravamotoru[2]=MOJA_ADRESA;
        spravamotoru[3]=0x05;
        spravamotoru[4]=0x2;
        
        crc=0;
        crc=ccc[crc^spravamotoru[1]];
        crc=ccc[crc^spravamotoru[2]];
        crc=ccc[crc^spravamotoru[4]];
        crc=ccc[crc^spravamotoru[5]];
        crc=ccc[crc^spravamotoru[6]];
        crc=ccc[crc^spravamotoru[7]];
        crc=ccc[crc^spravamotoru[8]];

        spravamotoru[9]=crc;
        
             int opakuj=1;
     while(opakuj==1){
       // odstranPotvrdenia();
        for(int p=0;p<=9;p++){
                        while(pc.writable()==0){}
        pc.putc(spravamotoru[p]);
        }
        
        //////////////////kym ubehne cas zistujem ci sa niekde v poli prijatych znakov nenachadza 
        timer.start();
        int milisecStart = timer.read_ms();

        int br;
        while((timer.read_ms()-milisecStart)<100){//kym je ubehnuty cas mensi ako 100 milisekund
        br=0;
                int pocetDat=0;
            if(indexcitania<=indexzapisu){
                pocetDat=indexzapisu-indexcitania;
            }else{
                pocetDat=(199-indexcitania+1)+indexzapisu;
            }
        for(int i=0;i<pocetDat-4;i++){
            if(kruhovybuffer[(indexcitania+i)%200]==0xA0&&kruhovybuffer[(indexcitania+1+i)%200]==0x00&&kruhovybuffer[(indexcitania+2+i)%200]==0x00&&kruhovybuffer[(indexcitania+3+i)%200]==0x00&&kruhovybuffer[(indexcitania+4+i)%200]==0x00){
                pc.putc(0xcc);                
                if(i!=0){
                for(int j=i-1;j>=0;j--){//pojde od indexu kde sa potvrdzovacia sprava nasla az po index citania
                    int odkial=(indexcitania+j)%200;
                    int kam=(odkial+5)%200;
                    kruhovybuffer[kam]=kruhovybuffer[odkial];
                }
                }    
                indexcitania=(indexcitania+5)%200;
                br=1; 
                opakuj=0;
                break;  
            }
            
            
        }     
        if(br==1){break;} 
        }  
        timer.stop();
        timer.reset();
        }//while opakuj==1
        }
        
        
void watchdogReset(){
    char watchdogRes[6];
        watchdogRes[0]=0xA0;
        watchdogRes[1]=WATCHDOG_TIMER;
        watchdogRes[2]=MOJA_ADRESA;
        watchdogRes[3]=0x01;
        watchdogRes[4]=0x02;

        crc=0;
        crc=ccc[crc^watchdogRes[1]];
        crc=ccc[crc^watchdogRes[2]];
        crc=ccc[crc^watchdogRes[4]];
        watchdogRes[5]=crc;
        
        for(int p=0;p<=5;p++){
           while(pc.writable()==0){}
        pc.putc(watchdogRes[p]);
        }
       
    }
    
void odstranPotvrdenia(){
        //////////////////kym ubehne cas zistujem ci sa niekde v poli prijatych znakov nenachadza 
        int br=0;
        while(br==0){
                int pocetDat=0;
            if(indexcitania<=indexzapisu){
                pocetDat=indexzapisu-indexcitania;
            }else{
                pocetDat=(199-indexcitania+1)+indexzapisu;
            }
        for(int i=0;i<pocetDat-4;i++){
            if(kruhovybuffer[(indexcitania+i)%200]==0xA0&&kruhovybuffer[(indexcitania+1+i)%200]==0x00&&kruhovybuffer[(indexcitania+2+i)%200]==0x00&&kruhovybuffer[(indexcitania+3+i)%200]==0x00&&kruhovybuffer[(indexcitania+4+i)%200]==0x00){
                pc.putc(0xbb);                
                if(i!=0){
                for(int j=i-1;j>=0;j--){//pojde od indexu kde sa potvrdzovacia sprava nasla az po index citania
                    int odkial=(indexcitania+j)%200;
                    int kam=(odkial+5)%200;
                    kruhovybuffer[kam]=kruhovybuffer[odkial];
                }
                }    
                indexcitania=(indexcitania+5)%200;
                break;  
            }
            
            if(i==pocetDat-5){
                br=1;
                }
        }      
        }  

    }    