#ifndef SAMPLEFILTER_H_
#define SAMPLEFILTER_H_

/*

FIR filter designed with
 http://t-filter.appspot.com

sampling frequency: 800 Hz

* 0 Hz - 50 Hz
  gain = 1
  desired ripple = 5 dB
  actual ripple = 2.914975479357161 dB

* 150 Hz - 400 Hz
  gain = 0
  desired attenuation = -40 dB
  actual attenuation = -43.03832555525106 dB

*/

#define SAMPLEFILTER_TAP_NUM 11

typedef struct {
  double history[SAMPLEFILTER_TAP_NUM];
  unsigned int last_index;
} SampleFilter;

void SampleFilter_init(SampleFilter* f);
void SampleFilter_put(SampleFilter* f, double input);
double SampleFilter_get(SampleFilter* f);

#endif