#include "Samplefilter.h"

static double filter_taps[SAMPLEFILTER_TAP_NUM] = {
  0.009364555465021395,
  0.04162548629009952,
  0.08783132195564536,
  0.14608632119801232,
  0.19260258113649567,
  0.21122159144894026,
  0.19260258113649567,
  0.14608632119801232,
  0.08783132195564536,
  0.04162548629009952,
  0.009364555465021395
};

void SampleFilter_init(SampleFilter* f) {
  int i;
  for(i = 0; i < SAMPLEFILTER_TAP_NUM; ++i)
    f->history[i] = 0;
  f->last_index = 0;
}

void SampleFilter_put(SampleFilter* f, double input) {
  f->history[f->last_index++] = input;
  if(f->last_index == SAMPLEFILTER_TAP_NUM)
    f->last_index = 0;
}

double SampleFilter_get(SampleFilter* f) {
  double acc = 0;
  int index = f->last_index, i;
  for(i = 0; i < SAMPLEFILTER_TAP_NUM; ++i) {
    index = index != 0 ? index-1 : SAMPLEFILTER_TAP_NUM-1;
    acc += f->history[index] * filter_taps[i];
  };
  return acc;
}