#include "mbed.h"
#include "math.h"
Ticker flipper;
Ticker flipper2;
DigitalOut led2(LED2);
AnalogIn sensor(p20);
AnalogIn sensor_visible(p19);
AnalogIn sensor_invisible(p18); 

//680 nm
#define visible 68 
//940 nm
#define invisible 94
float data =0; 
float previous_data =0;
int count1=-1;
int count2=-1;
float max1 =0.0;
float max2 =0.0;
float global_max =0.0;
int running_count=0;  
bool foundMax = false;
bool firstRun = true; 
float difference = 0.05;
#define count_period 0.1
void reset();
float normalization();
void flip() {
    led2 = !led2;
    previous_data = data; 
   // printf("Data = %f\t",data);
    data = sensor.read() * 3.3;
    running_count++;  
   // printf("data = %f\n",data);
    if (data - previous_data > 0){
        //increasing 
        printf("Increasing \n");
        //do nothing
    }     
    else if(data - previous_data < 0 && !foundMax){
        //check if foundMax
        printf("Decrease\n");    
        if(firstRun){
            float diff = data - global_max;
            float negative = -1*difference;
           // printf("diff = %f\n",diff);
         //   printf("difference = %f,\t \t \t negative = %f \n", difference, negative);
            //printf("data = %f\n",data);
            printf("global_max = %f\n",global_max);
            //printf("------------ End\n");
            if(diff < difference && diff >negative) {
                printf("Within the range of first max, confident\n");
                printf("found max, data= %f\n",data);        
                foundMax = true;
                count1 = running_count; 
                max1 = data;  
                firstRun = false;   
            }
        }
        else{
                printf("found max, data= %f\n",data);        
                foundMax = true;
                count1 = running_count; 
                max1 = data;  
        } 
    }
    else if(data - previous_data < 0 && foundMax){
        printf("Decrease \t \n");
        if(((max1-data) < difference) && ((max1-data) > -1*difference)){
        //found second max; 
            printf("max1 = %f\n",max1);
            printf("found second max,data = %f \n",data);
            count2 = running_count;     
            float period = (count2 - count1)* count_period; 
            float BPM = (1.0/period) * 60.0;
            printf("Period = %f\n",period);
            printf("BPM = %f\n",BPM);
          //  exit(1);
            wait(5);
            reset();     
            printf("\n");
            printf("\n");
            printf("\n");
        }
        else {
            if((running_count - count1)*count_period > 1.5) {
                printf("Optimization filter by hand \t, reset\n");
                reset();    
            }    
        }   
    }
    else{
    }
    //reset if not found max for 5 seconds. 
    if(!foundMax && running_count*count_period>5){
        reset();
    }
}

void reset(){
        //reset
        printf("reset\n");
        global_max = normalization(); 
        printf("new normalization = %f",global_max);       
        count1 = 0;
        count2 = 0; 
        foundMax = false; 
        max1 = 0.0;
        running_count = 0; 
        firstRun = true; 
}

float normalization(){
    float max_input = -1.0; 
    float data_input;
    //normalize the data input 
    //find the max in 5 seconds; 
    for (int x=0;x<50;x++){
        data_input = sensor.read() * 3.3;
        if(data_input > max_input)max_input = data_input; 
        wait_ms(50);
    }
    difference = max_input * 0.35; 
    return max_input; 
}


void findOxygenSaturation(){
    float v = log10f(sensor_visible.read()*3.3) * visible;
    float iv = log10f(sensor_invisible.read()*3.3) * invisible; 
    printf("visible = %f\n",v);
    printf("invisible = %f\n",iv);
    float ratio = v/iv;
    printf("ratio = %f\n",ratio);
    float spo = -0.3393 * ratio + 1.1595 ;
    printf("spo = %f\n",spo);
}


int main() {
    led2 = 1;
    //comment out the below line to test heart rate 
    //the heart rate test subroutine, once it find the heart rate, it will terminate the program.
    //so make sure you reset the MBED
    global_max = normalization();
    printf("normalization = %f",global_max); 
    flipper.attach(&flip, count_period); // the address of the function to be attached (flip) and the interval (1 seconds)    
    //read OxygenSaturation Every two second. 
    //use pin 19 for visible light input
    //use pin 18 for invisible light input
//    flipper2.attach(&findOxygenSaturation,2.0);

    while(1) {
    }
}