
#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include  "TextLCD.h"
#include "PinDetect.h"
#include <string>

#include <vector>

SDFileSystem sd(p5, p6, p7, p8,p9, "sd"); //SD card
TextLCD myLCD(p22, p23, p24, p25, p26, p27); //TextLCD
AnalogOut DACout(p18);
//AnalogOut DACout(p20);

void read_file_names(char *);
void volumePressed();
wave_player waver(&DACout);
vector<string> filenames; //filenames are stored in a vector string
PinDetect pb1(p28);  // Up button - scrolls up the list
PinDetect pb2(p29);  // Down button - scrolls down the list
PinDetect pb3(p30);  // Play/Pause- selects and plays or pauses the filename
PinDetect pb4(p15);
int volatile Scrollup=0; // heat to temp
int volatile Scrolldown=0;// cool to temp
int volatile total=0; // heat or cool mpde
bool  select=false;
bool *selectptr=&select;


void pb1_hit_callback (void)
{
    Scrollup++;
    

    if(Scrollup >= total)
        Scrollup=0;

}
// Callback routine is interrupt activated by a debounced pb2 hit
void pb2_hit_callback (void)
{

    Scrollup--;
    if(Scrollup < 0)
        Scrollup = total-1;
}

// Callback routine is interrupt activated by a debounced pb3 hit

void pb3_hit_callback (void)
{
    select=!select;
}
// Callback routine is interrupt activated by a debounced pb3 hit
void pb4_hit_callback (void)
{

   volumePressed();



}
int main()
{
// Use internal pullups for the three pushbuttons
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    // Delay for initial pullup to take effect
    wait(.01);
    //Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    pb3.attach_deasserted(&pb3_hit_callback);
    pb4.attach_deasserted(&pb4_hit_callback);
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    pb3.setSampleFrequency();
    pb4.setSampleFrequency();

    
    // myLCD.printf("\n\n\nHello, wave world!\n");
 // wave_file = fopen("/sd/myMusic", "r");
 bool SDcard=0;
 while(!SDcard)
 { SDcard=sd.sd_inserted();
   if( SDcard==false){
   myLCD.locate(0,0);
    myLCD.printf("Insert SDCARD");
    }
    else 
     myLCD.cls();
 }
 FILE *wave_file;
    read_file_names("/sd/myMusic");
    string directory;
      directory="/sd/myMusic";
        string song;
         
        
    while(1) {
        //int pos=size((*it).c_str())-4;
        int index=0;
        index=Scrollup;
        int len=filenames[index].size();
        
        myLCD.cls();
        myLCD.locate(0,0);
        myLCD.printf("%s",filenames[index].substr(0,len-4));
      
        if(select==true) {
        song = directory + "/" + filenames[index];
         wave_file = fopen(song.c_str(), "r");
         myLCD.locate(0,1);
         myLCD.printf("%s","Now Playing");
            waver.play(wave_file,selectptr);
            select=false;
            fclose(wave_file);
            
        }
        else
        //myLCD.cls();
        //myLCD.printf("%d",Scrollup);
        //myLCD.printf("%s","now playing");
        //waver.play(wave_file);
        wait(0.3);
    }





}


void read_file_names(char *dir)

{

    DIR *dp;

    struct dirent *dirp;

    dp = opendir(dir);

    //read all directory and file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) {
        filenames.push_back(string(dirp->d_name));
        total++;
    }
    }
void volumePressed(){
 
           
            
            int *volumeMod=waver.getVolumeMod();

            *volumeMod = *volumeMod + 1;

            if (*volumeMod >= 16)

            *volumeMod  = 0;
}










