/*
 * Adafruit NeoPixel 8x8 matrix example
 *
 * This program displays a couple simple patterns on an 8x8 NeoPixel matrix.
 *
 * 3 buttons are used for DigitalIns, 2 control the brightness up and down,
 * and the third switches patterns
 */

#include "mbed.h"
#include "NeoStrip.h"
#include "text.h"
#define N 128
#define PATTERNS 4
#include <string>
int hueToRGB(float h);
void pattern0();
void pattern1();
void pattern2();
void fillBlue();
void progressBar(bool);
int getIndex(int, int);
void putChar(int row, int col, char ch, int color);
void putString(std::string);
void loopAscii(int count);
void MarioBox();
void drawBox(int row);void emptyBox(int row);
void putCharV(int row, int col, char ch, int color);
// array of function pointers to the various patterns
//void (*patterns[])(void) = {&pattern0, &pattern1, &pattern2};

NeoStrip strip(p18, N);
DigitalIn b1(p20); // brightness up
DigitalIn b2(p19); // brightness down
DigitalIn b3(p21); // next pattern

// timer used for debugging
Timer timer;
int chars[128];
char ch = 'A';

int main()
{
    
    std::string emoji[9] = {"*_*", "^_^", "$_$", ">_<", "=_=", "+_=", ":)", ":(", ":3"};
    float bright = 0.2; // 20% is plenty for indoor use
    strip.setBrightness(bright);    // set default brightness
    int count = 0;
    while (true)
    {
        timer.reset(); // use a timer to measure loop execution time for debugging purposes
        timer.start(); // for this application, the main loop takes approximately 3ms to run
progressBar(true);
wait(5);
progressBar(false);

//  fillBlue();

    // write character
//  MarioBox();
//  displayEmoji();
//  loopAscii(count);
//  ch+=2;
//  putString(emoji[count%9]);
//  count++;
    wait(2);
        timer.stop();
        // print loop time if b3 is pressed     
        wait_ms(10);
    }
}

// pattern0 displays a static image
void pattern0()
{
    fillBlue();
    // write character
    int color = 0xffff00;   
    putChar(0,0,'G',color);
    putChar(0,6,'O',color);     
    strip.setPixels(0, N, chars);
}

// display a shifting rainbow, all colors have maximum
// saturation and value, with evenly spaced hue
void pattern1()
{
    static float dh = 360.0 / N;
    static float x = 0;

    for (int i = 0; i < N; i++)
        strip.setPixel(i, hueToRGB((dh * i) - x));
    
    x += 1;
    if (x > 360)
        x = 0;
}



// Converts HSV to RGB with the given hue, assuming
// maximum saturation and value
int hueToRGB(float h)
{
    // lots of floating point magic from the internet and scratching my head
    float r, g, b;
    if (h > 360)
        h -= 360;
    if (h < 0)
        h += 360;
    int i = (int)(h / 60.0);
    float f = (h / 60.0) - i;
    float q = 1 - f;
    
    switch (i % 6)
    {
        case 0: r = 1; g = f; b = 0; break;
        case 1: r = q; g = 1; b = 0; break;
        case 2: r = 0; g = 1; b = f; break;
        case 3: r = 0; g = q; b = 1; break;
        case 4: r = f; g = 0; b = 1; break;
        case 5: r = 1; g = 0; b = q; break;
        default: r = 0; g = 0; b = 0; break;
    }
    
    // scale to integers and return the packed value
    uint8_t R = (uint8_t)(r * 255);
    uint8_t G = (uint8_t)(g * 255);
    uint8_t B = (uint8_t)(b * 255);

    return (R << 16) | (G << 8) | B;
}

void fillBlue(){
    for(int i = 0; i < N; i++){
        chars[i] = 0x122446;
    }   
}

int getIndex(int r, int c){
    if(c < 8){
        return (r * 8 + c);
    }else if(c > 15){
        return -1;      
    }
    else{
        return (64 + r * 8 + (c-8));
    }
}


void putChar(int row, int col, char ch, int color){
        for(int r = 0; r < 8; r++){
            for(int c = 0; c < 6; c++){
                if(fontdata_6x8[ch * 48 + r * 6 +c]){
                    int idx = getIndex(row+r, col+c);
                    if(idx != -1)
                        chars[idx] = color; 
                }
            }
    }
}
void putCharV(int row, int col, char ch, int color){
        for(int r = 0; r < 8; r++){
            for(int c = 0; c < 6; c++){
                if(fontdata_6x8[ch * 48 + r * 6 +c]){
                    int idx = (row + r) *8 +( col +c);
                    if(idx != -1)
                        chars[idx] = color; 
                }
            }
    }
}

void MarioBox(){
        int color = 0xffff00;
        int red = 0xff0000;
        
        drawBox(8);
        strip.setPixels(0, N, chars);
        strip.write();      
        wait(5);

        for(int i = 1; i < 3; i++){
            fillBlue();
            drawBox(8-i);
            strip.setPixels(0, N, chars);
            strip.write();      
            wait(0.3);
        }       
        for(int i = 0; i < 3; i++){
            fillBlue();
            drawBox(6 + i);
            strip.setPixels(0, N, chars);
            strip.write();      
            wait(0.3);
        }
        fillBlue();
        emptyBox(8);
        putChar(0,0,'0',color);
        strip.setPixels(0, N, chars);
        strip.write();
        wait(30);       
}
void putString(std::string str){
    int color = 0xffff00;
    for(int i = 0; i < str.length(); ++i){
        putChar(0,5*i,str[i], color);       
    }   
    strip.setPixels(0, N, chars);
    strip.write();

}

void loopAscii(int count){
    int color = 0xffff00;
    putChar(0,0,ch+count,color);
    putChar(0,6,ch+count+1,color);
    strip.setPixels(0, N, chars);
    strip.write();
}

void drawBox(int row){
    for(int i = 0; i < 64; ++i)
        chars[row*8 + i] = 0x000000;
    putCharV(row,0,'?',0xffff00);   
}
void emptyBox(int row){
    for(int i = 0; i < 64; ++i)
        chars[row*8 + i] = 0x000000;
}
void progressBar(bool up){
    int index;
    int init;
    int increment;
    int color;
    if(up == true){
         init = 0;
         increment = 1;
         color = 0x122446;
    }else {
         init = 15;
         increment = -1;
        fillBlue();
         color = 0x000000;
    }
    
    for(int x = 0; x < 16 ; x++){
        
        for (int j = 0; j < 8; j++){
            index = getIndex(j,init + increment * x);
            chars[index] = color;
        }
    strip.setPixels(0, N, chars);
    strip.write();
        wait(1);
    }
}