#include "mbed.h"
#include "TinyGPS.h"

#ifndef MBED_GPS_H
#define MBED_GPS_H

 
/**  A GPS interface for reading from a Globalsat EM-406 GPS Module */
class GPS {
public:
 
    /** Create the GPS interface, connected to the specified serial port
     */    
    GPS(PinName tx, PinName rx);
    
    //Checks if GPS (Serial Object) is connected
    bool isConnected();
    
    //Does GPS Module have lock on satellite
    bool isLocked();
    
    //parses incoming NMEA standard strings from GPS Module 
    void parseNMEA(); 
    
    double f_lat, f_lon, f_altitude, f_course, knots,mph, mps,kmph, f_hdop;
    
    long lat, lon, altitude, hdop; 
    
    unsigned long course, age; //how long a fix has lasted to satellite in ms
    
    int year;
    byte month, day, hour, minute, second;
    
    unsigned long sat_count,speed;
    
     
private:

Serial _gps; 

TinyGPS gpsr;
  
 
};
 
#endif