#include "gps.h"


GPS::GPS(PinName tx, PinName rx) : _gps(tx, rx) {
    _gps.baud(9600);
            
}

bool GPS::isConnected() {
     
     return _gps.readable();
     
    }
    
bool GPS::isLocked(){
        
        return(gpsr.encode(_gps.getc()));
        
        }
        
void GPS::parseNMEA(){
    (void)gpsr.crack_datetime(&year, &month, &day, &hour, &minute, &second);
     sat_count = gpsr.sat_count(); 
     
     
     (void)gpsr.f_get_position(&f_lat, &f_lon, &age); //fix age in milliseoconds
     f_altitude = gpsr.f_altitude(); 
     f_course = gpsr.f_course(); //course over ground Magnetic Variation in degrees 
     f_hdop = gpsr.f_hdop(); //horizontal dilution of precision
     kmph = gpsr.f_speed_kmph();
     knots = gpsr.f_speed_knots();
     mph = gpsr.f_speed_mph();
     mps = gpsr.f_speed_mps();
     
     
     (void)gpsr.get_position(&lat, &lon, &age); //fix age in milliseoconds
     altitude = gpsr.altitude(); 
     course = gpsr.course(); //course over ground Magnetic Variation in degrees 
     hdop = gpsr.hdop(); //horizontal dilution of precision
     speed = gpsr.speed(); //speed in 100ths of a knot   
}    