#include "mbed.h"
 #include "DS1820.h"
 
 Serial      pc(USBTX, USBRX);
 DigitalOut  led(LED1);
 DS1820      ds1820(D8);  // substitute D8 with actual mbed pin name connected to 1-wire bus
 float       temp = 0;
 int         result = 0;
 
 int main()
 {
     pc.printf("\r\n--Starting--\r\n");
     if (ds1820.begin()) {
         while (1) {
             ds1820.startConversion();   // start temperature conversion from analog to digital
             wait(1.0);                  // let DS1820 complete the temperature conversion
             result = ds1820.read(temp); // read temperature from DS1820 and perform cyclic redundancy check (CRC)
             switch (result) {
                 case 0:                 // no errors -> 'temp' contains the value of measured temperature
                     pc.printf("temp = %3.1f%cC\r\n", temp, 176);
                     break;
 
                 case 1:                 // no sensor present -> 'temp' is not updated
                     pc.printf("no sensor present\n\r");
                     break;
 
                 case 2:                 // CRC error -> 'temp' is not updated
                     pc.printf("CRC error\r\n");
             }
 
             led = !led;
         }
     }
     else
         pc.printf("No DS1820 sensor found!\r\n");
 }