#include "mbed.h"
#include "MMA8451Q.h" 
#include "USBMouse.h"
#include "TSISensor.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

USBMouse mouse;
MMA8451Q acc(PTE25, PTE24,MMA8451_I2C_ADDRESS);
TSISensor tsi;

int main(void) {
    while (1) {
        if (tsi.readPercentage())
        {
            if (tsi.readDistance() >= 20)
            {
                mouse.press(MOUSE_LEFT);
            }
            else
            {
                mouse.press(MOUSE_RIGHT);
            }
        }
        else
        {
            mouse.release(MOUSE_LEFT);
            mouse.release(MOUSE_RIGHT);
        }
        mouse.move(acc.getAccY()*(-5), acc.getAccX()*(-5));
    }
}