#ifndef Odometry_H
#define Odometry_H

#include <vector>
#include "mbed.h"
#include "math.h"
#define M_PI           3.14159265358979323846  /* pi */


class Robot
{
  public:
    Robot(float width, float countPerMeter);
    
    /* returns radius in [m]. When turning right, radius is negativ
     *    left is positive
    */ 
    float getRadius(float v1, float v2);
    void countRadius(float v1, float v2);
    
    /* returns speed in format 
     *      [0] = linear x
     *      [1] = linear y
     *      [2] = angular z
     *
     * function needs actual R     
     */         
    std::vector<float> getSpeed(std::vector<int> encoders);
  
    std::vector<float> getMotorRatio(float x, float z);

  private:  
    float _w;         // width
    float _R;
    uint32_t _countPerMeter;
    
    std::vector<float> _odom;
    std::vector<float> _ratio;
};

#endif