// original sources Sam Thys - https://os.mbed.com/users/sammekevremde/code/Snake/
// modified by: zaphodikus Jul 2018
// uses thermometer and accelerometer on the LPC7760 to generate random
// fruit positions
#include "mbed.h"
#include "C12832_lcd.h"
#include "LM75B.h"
#include "MMA7660.h"

MMA7660 MMA(p28,p27); // accelerometer
C12832_LCD lcd;
Ticker gameticker;
LM75B tmp(p28,p27); // I2C Temperature Sensor

//-- Variable --
enum direction { up, down, left, right, null};
enum gamemode { start,stop,run,pause};
direction currentdirection;
direction lastdirection;
gamemode game;
// -- Classes --
struct point
{
     int x;
     int y;
    };
//---------------------
struct point snakeHead;
struct point fruit;
int countFruit=0;
float board_temp;

point* snakeBody=new point[countFruit+5];
// -- I/O setting --
InterruptIn upHandler(p12);
InterruptIn downHandler(p15);
InterruptIn leftHandler(p13);
InterruptIn rightHandler(p16);
InterruptIn centerHandler(p14);

// -- Functions --

void placeFruit()
{
    board_temp = tmp;
    
    int data[3];
    MMA.readData((int*)&data);
    srand(data[0]*192 + data[1]*192 + data[2]*192 + board_temp*2048);
    fruit.x = rand() % 126 +1;  
    fruit.y = rand() % 30 +1; 
}

void direction_up()
{
    if ( currentdirection!=down)
        currentdirection=up;
}
void direction_down()
{
    if ( currentdirection!=up)
        currentdirection=down;
}
void direction_left()
{
    if ( currentdirection!=right)
        currentdirection=left;
}
void direction_right()
{
    if ( currentdirection!=left)
        currentdirection=right;
}
    
void center_button()
{
    if (game==pause)
    {
        currentdirection=lastdirection;
        game=run;
    }
    else if (game==run)
    {
        lastdirection=currentdirection;
        currentdirection=null;
        game=pause;
    }
    else if (game==stop)
    {
        for (int i=0;i<=4;i++)
        {
            snakeBody[i].x=(snakeHead.x)-(i+1);
            snakeBody[i].y=15;
        }
        currentdirection=null;
        game=run;
    }
}

void tickHandler() 
{

    if (game==run)
    {
       if (currentdirection!=null)
        {
            for (int j=(countFruit+4);j>=1;j--)
            {
                snakeBody[j]=snakeBody[j-1];
            }
            snakeBody[0]=snakeHead;
        }
        
        switch (currentdirection)
        {
            case up:
                snakeHead.y+=1;
                break;
            case down:
                snakeHead.y-=1;
                break;
            case left:
                snakeHead.x-=1;
                break;
            case right:
                snakeHead.x+=1;
                break;
            
         }        
         
         if ((snakeHead.y == 0 ||snakeHead.y == 31 ||snakeHead.x == 127 ||snakeHead.x == 0) )
         {
             lcd.cls();
            lcd.locate(25,5);
            lcd.printf("Game Over!!");
            lcd.locate(25,15);
            lcd.printf("Score > %d",countFruit);
            currentdirection=null;
            snakeHead.x=15;
            snakeHead.y=15;
            game=stop;
            countFruit=0;
         }
         else if ((snakeHead.y == fruit.y )&& (snakeHead.x == fruit.x)  )
         {
            countFruit +=1;
            placeFruit();
         }
         else
         {
             lcd.cls();
            lcd.pixel(snakeHead.x,snakeHead.y,1);
            lcd.copy_to_lcd();
            for(int k=0;k<=(countFruit +4);k++)
            {
                lcd.pixel(snakeBody[k].x,snakeBody[k].y,1);
            }
            lcd.pixel(fruit.x-1,fruit.y-1, 1);
            lcd.pixel(fruit.x-1,fruit.y, 1);
            lcd.pixel(fruit.x-1,fruit.y+1, 1);
            lcd.pixel(fruit.x,fruit.y-1, 1);
            lcd.pixel(fruit.x,fruit.y, 1);
            lcd.pixel(fruit.x,fruit.y+1, 1);
            lcd.pixel(fruit.x+1,fruit.y-1, 1);
            lcd.pixel(fruit.x+1,fruit.y, 1);
            lcd.pixel(fruit.x+1,fruit.y+1, 1);
            lcd.rect(0,0, 127, 31, 1);
            lcd.copy_to_lcd();
         }
         
        for (int a=0;a<=(countFruit +4);a++)
        {
            if ( snakeBody[a].x==snakeHead.x && snakeBody[a].y==snakeHead.y)
               {
                    lcd.cls();
                    lcd.locate(25,5);
                    lcd.printf("Game Over!!");
                    lcd.locate(25,15);
                    lcd.printf("U score is %d",countFruit
            );
                    currentdirection=null;
                    snakeHead.x=15;
                    snakeHead.y=15;
                    game=stop;
                    countFruit
                =0;
                    
                }
        }
    }
    else if (game==pause)
    {
        lcd.cls();
        lcd.locate(30,15);
        lcd.printf("pause");
    }
}


//--------------------------------
int main()
{
    game=run;
    lcd.rect(0, 0, 127, 31, 1);
    lcd.copy_to_lcd();
    currentdirection=null;
    snakeHead.x=15;
    snakeHead.y=15;
    for (int i=0;i<=4;i++)
    {
        snakeBody[i].x=(snakeHead.x)-(i+1);
        snakeBody[i].y=15;
    }
    placeFruit();
    gameticker.attach(&tickHandler, 0.1);
    // set interrupt handlers
    upHandler.rise(&direction_up);
    downHandler.rise(&direction_down);
    leftHandler.rise(&direction_left);
    rightHandler.rise(&direction_right);
    centerHandler.rise(&center_button);

    while (1)
    {

    }
}