//*****************************************************************************
//
//	STM32 Game Development Platform V1.0
//
//	(c) Copyright 2012 by Artekit Italy
//	
//	Written by Ruben H. Meleca
//	
//	Release date: Apr-9-2012
//*****************************************************************************

#ifndef	__SPACE_INVADERS_H
#define	__SPACE_INVADERS_H


// Buttons definition

#define	SI_FIRE_BUTTON			GPIO_Pin_0
#define	SI_LEFT_BUTTON			GPIO_Pin_5
#define	SI_RIGHT_BUTTON			GPIO_Pin_4




#define	SI_MAXGOODBOYS			4
#define	SI_GOODBOYSTART_X		150
#define	SI_GOODBOYSTART_Y		150
#define SI_GOODBOYSTART_VX		0
#define SI_GOODBOYSTART_VY		0
#define	SI_GOODBOYSHOTPOINT		11
#define	SI_GOODBOYSKEYDELAY		16
#define	SI_GOODBOMBDELAY		5

#define A_ASTEROIDBIG_RADIUS    15
#define A_ASTEROIDMEDIUM_RADIUS 10
#define A_ASTEROIDSMALL_RADIUS  5



#define	SI_DEAD					0
#define	SI_ALIVE				1
#define	SI_DESTROYED			2
#define	SI_CANCEL				3

#define	SI_BOMBFREE				0
#define	SI_BOMBACTIVE			1




typedef /* __packed */ struct {

	i16			x;			// X position
	i16			y;			// Y position
	u8			flip;		// Bitmap select
	u8			mode;		// 0=Free, 1=Active

}	SI_BOMB;



typedef /* __packed */struct {

	i16			x;			// X position
	i16			y;			// Y position
	i16			radius;		// Radius
	i16 		direction;	// Direction
	u8			mode;		// 0=Free, 1=Active
	
	pu8 		b1 			// explosion Bitmap

} A_ASTEROID;

//	Function declarations

void	siInit(void);

#endif // __SPACE_INVADERS_H

