/***************************************************************************
 * STM32 VGA demo
 * Copyright (C) 2012 Artekit Italy
 * http://www.artekit.eu
 * Written by Ruben H. Meleca
 
### space_invaders.c
 
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#include "stm32f30x.h"
#include "sys.h"
#include "video.h"
#include "gdi.h"
#include "asteroids.h"
//#include <string.h>
//#include <stdio.h>
//#include <stdlib.h>

extern volatile u32    sysTicks;




extern u8				siLogo[VID_VSIZE][VID_HSIZE];

//extern volatile u32		sysTicks;




								
const u8	aAsteroid15[] = {	0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00,
								0x00, 0x00,0x00, 0x00
								 };


const u8	siGoodBoys[] = {	
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x01, 0x80,
								0x01, 0x80,
								0x02, 0x40,
								0x02, 0x40,
								0x02, 0x40,
								0x04, 0x20,
								0x04, 0x20,
								0x04, 0x20,
								0x08, 0x10,
								0x08, 0x10,
								0x0f, 0xf0, 
								0x00, 0x00, 
								0x00, 0x00 };

								
const u8	siGoodBoysU[] = {	
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x01, 0x80,
								0x01, 0x80,
								0x02, 0x40,
								0x02, 0x40,
								0x02, 0x40,
								0x04, 0x20,
								0x04, 0x20,
								0x04, 0x20,
								0x08, 0x10,
								0x08, 0x10,
								0x0f, 0xf0, 
								0x00, 0x00, 
								0x00, 0x00 };
				
				
				
								

								
const u8	siGoodBoysUR[] = {	
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x70,
								0x03, 0x90,
								0x1c, 0x10,
								0x20, 0x20,
								0x10, 0x20,
								0x08, 0x20,
								0x04, 0x40,
								0x02, 0x40,
								0x01, 0x40,
								0x00, 0x80, 
								0x00, 0x00, 
								0x00, 0x00 };
								
const u8	siGoodBoysUL[] = {	
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x0e, 0x00,
								0x09, 0xc0,
								0x08, 0x38,
								0x04, 0x04,
								0x04, 0x08,
								0x04, 0x10,
								0x02, 0x20,
								0x02, 0x40,
								0x02, 0x80,
								0x01, 0x00, 
								0x00, 0x00, 
								0x00, 0x00 };
								
const u8	siGoodBoysDR[] = {	
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x80,
								0x01, 0x40,
								0x02, 0x40,
								0x04, 0x40,
								0x08, 0x20,
								0x10, 0x20,
								0x20, 0x20,
								0x1c, 0x10,
								0x03, 0x90,
								0x00, 0x70,
								0x00, 0x00,
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00 };
								
const u8	siGoodBoysDL[] = {	
								0x00, 0x00,
								0x00, 0x00,
								0x01, 0x00,
								0x02, 0x80,
								0x02, 0x40,
								0x02, 0x20,
								0x04, 0x10,
								0x04, 0x08,
								0x04, 0x04,
								0x08, 0x38,
								0x09, 0xc0,
								0x0e, 0x00,
								0x00, 0x00,
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00 };

								
const u8	siGoodBoysR[] = {	
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00, 
								0x00, 0x00, 
								0x38, 0x00,//
								0x27, 0x00,
								0x20, 0xe0,
								0x20, 0x18,
								0x20, 0x18,
								0x20, 0xe0,
								0x27, 0x00,
								0x38, 0x00,//
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00 };
								
const u8	siGoodBoysL[] = {
								0x00, 0x00,
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00,
								0x00, 0x1c, 
								0x00, 0xe4, 
								0x07, 0x04, 
								0x18, 0x04, 
								0x18, 0x04, 
								0x07, 0x04, 
								0x00, 0xe4, 
								0x00, 0x1c, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00,
								0x00, 0x00 };
							
const u8	siGoodBoysD[] = {	
								0x00, 0x00,
								0x00, 0x00,
								0x0f, 0xf0,
								0x08, 0x10,
								0x08, 0x10,
								0x04, 0x20,
								0x04, 0x20,
								0x04, 0x20,
								0x02, 0x40,
								0x02, 0x40,
								0x02, 0x40,
								0x01, 0x80,
								0x01, 0x80,
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00 };
							
								

								
								
const u8	siGoodBoysBlk[] = {	0x00, 0x00,
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00,
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00,
								0x00, 0x00 };



const u8	siGoodBomb1[] = {	0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00 };
const u8	siGoodBomb2[] = {	0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };



void numtostr(char *buffer,int n);

const pu8	siVesselPoints[] = {
				"LARGE  = 10 POINTS",
				"MEDIUM = 20 POINTS",
				"SMALL  = 30 POINTS" };

const pu8	siPressKey = "PRESS ANY BUTTON TO START GAME";


#define CCM __attribute__ ((section (".ccmram"))) static
;
static A_ASTEROID 	aAsteroid[30];



static	i16			siXGoodBoy = SI_GOODBOYSTART_X;
static	i16			siYGoodBoy = SI_GOODBOYSTART_Y;
static  i16			siXGoodBoyV = SI_GOODBOYSTART_VX;
static  i16			siYGoodBoyV = SI_GOODBOYSTART_VY;

static	i16			siGoodBoyCount;
static	i16			siGoodBoyCountOld;

static	i16			siGoodBoysKeyDelay;
static	i16			siGoodBombDelay;
static	i16			siGoodBombActive;
static	i16			siGoodBombX;
static	i16			siGoodBombY;
static  i16 		siGoodBombDirection;
static	i16			siGoodBombKeyState;

static	i16			siCurrentScore;
static	i16			siBakScore;
static	i16			siBestScore;

static  i16			aAsteroidCount;    			// Count asteroids. If 0 you win


static  i16 		aLevel;
static	u8			siScore[24];
static	float 		AccBuffer[3] = {0.0f};


//#undef static

u8	siAnyButtonPressed(void) {

u32		b;

	b = GPIOA->IDR;
	return (b&SI_FIRE_BUTTON);
	if ((b & 0x00000001) != (SI_FIRE_BUTTON/* | SI_LEFT_BUTTON | SI_RIGHT_BUTTON*/)) return(1);
	return(0);
}

void siYouWin(void) {

	vidClearScreen();
	gdiRectangle(0,0,(VID_PIXELS_X - 1),VID_VSIZE - 1,0);

	strcpy((char*) siScore,"SCORE : ");
                	numtostr(siScore+7,siCurrentScore);

			
	aLevel = 0;
	gdiDrawTextEx(167,80,"* YOU WIN *",GDI_ROP_XOR);
	gdiDrawTextEx(177,75,siScore,GDI_ROP_XOR);
	//gdiDrawTextEx(187,95,siScore,GDI_ROP_XOR);
	while(1) {
		sysDelayMs(200);
		if (siAnyButtonPressed()) return;
		gdiDrawTextEx(108,170,siPressKey,GDI_ROP_XOR);
		sysDelayMs(400);
		if (siAnyButtonPressed()) return;
		gdiDrawTextEx(108,170,siPressKey,GDI_ROP_XOR);
		if (siAnyButtonPressed()) return;
	};
}

void siYouLose(void) {

	vidClearScreen();
	gdiRectangle(0,0,(VID_PIXELS_X - 1),VID_VSIZE - 1,0);
	
	aLevel = 0;
	gdiDrawTextEx(164,80,"* YOU LOSE *",GDI_ROP_XOR);
	while(1) {
		if (siAnyButtonPressed()) return;
		gdiDrawTextEx(108,170,siPressKey,GDI_ROP_XOR);
		sysDelayMs(400);
		if (siAnyButtonPressed()) return;
		gdiDrawTextEx(108,170,siPressKey,GDI_ROP_XOR);
		if (siAnyButtonPressed()) return;
		sysDelayMs(200);
	};

}

char * strcpy(char *dest, char *src) {
	while(*dest++=*src++);
	return dest;
}

int strlen(const char *str)
{
        const char *s;
        for (s = str; *s; ++s)
                ;
        return (s - str);
}

void siInitialScreen(void) {

u16		i, x, y, l, j;
pu8		ptr = NULL;
u8		buf[] = " ";

	vidClearScreen();

	gdiRectangle(0,0,(VID_PIXELS_X - 1),VID_VSIZE - 1,0);

	gdiDrawTextEx(130, 85, "159.233 ASSIGNMENT 2", GDI_ROP_COPY);
	gdiDrawTextEx(156, 55, "ASTEROIDS", GDI_ROP_COPY);
	gdiDrawTextEx(130, 70, "ZANE LAMB 15160640", GDI_ROP_COPY);

	sysDelayMs(1000);

	gdiDrawTextEx(130,110,"* SCORING SYSTEM *",GDI_ROP_XOR);
	sysDelayMs(400);
	y = 125;
	for (i = 0; i < 3; i++) {
		x = 112;
		
		x += 20;
		l = strlen((const char*)siVesselPoints[i]);
		ptr = siVesselPoints[i];
		for (j = 0; j < l; j++) {
			sysDelayMs(25);
			buf[0] = *ptr++;
			gdiDrawTextEx(x,y + 2,buf,GDI_ROP_COPY);
			x += 6;
		}
		y += 12;
		sysDelayMs(300);
	}
	while(1) {
		if (siAnyButtonPressed()) return;
		gdiDrawTextEx(108,170,siPressKey,GDI_ROP_XOR);
		sysDelayMs(400);
		if (siAnyButtonPressed()) return;
		gdiDrawTextEx(108,170,siPressKey,GDI_ROP_XOR);
		if (siAnyButtonPressed()) return;
		sysDelayMs(200);

	};

}


CCM void aCreateNewAsteroid(i16 index){
	if(aAsteroid[index].radius == 5) return;
	i16 i = 0;
	
	i16 tempRadius = aAsteroid[index].radius;
	i16 tempX = aAsteroid[index].x;
	i16 tempY = aAsteroid[index].y;
	i16 tempDirection = aAsteroid[index].direction;
	
	
	while(aAsteroid[i].mode != 0) i++; //find a free asteroid
	aAsteroid[i].radius = tempRadius-5;
	aAsteroid[i].x = tempX-5;
	aAsteroid[i].y = tempY-5;
	aAsteroid[i].direction = (tempDirection + 1) % 8;	
	aAsteroid[i].mode = 1;
	
	while(aAsteroid[i].mode != 0) i++; //find another  free asteroid
	aAsteroid[i].radius = tempRadius-5;
	aAsteroid[i].x = tempX+5;
	aAsteroid[i].y = tempY+5;
	if(tempDirection == 0){
		aAsteroid[i].direction = 8;
	}else{
		aAsteroid[i].direction = tempDirection - 1;	
	}
	aAsteroid[i].mode = 1;
	
	aAsteroidCount += 2;
}
	
volatile float asteroidMoveTimer;
volatile float asteroidMoveStartTime;
volatile int asteroidMoveRecently;
	
CCM void aMoveAsteroid(void){
	
	if(aAsteroidCount == 0) return;
	
	if(asteroidMoveRecently == 0){
		for(int i = 0; i < aLevel * 4; i++){
			if(aAsteroid[i].mode == 1){
				
		
				gdiBitBlt(NULL,aAsteroid[i].x-aAsteroid[i].radius,aAsteroid[i].y-aAsteroid[i].radius,(aAsteroid[i].radius *2) + 2,(aAsteroid[i].radius *2) + 2,(pu8) aAsteroid15,GDI_ROP_COPY);
			
				
				
				switch(aAsteroid[i].direction){
					case 0:	
						aAsteroid[i].y -= 2;
						break;
					case 1:
						aAsteroid[i].x -= 1;	
						aAsteroid[i].y -= 1;
						break;
					case 2:
						aAsteroid[i].x -= 2;	
						break;
					case 3:
						aAsteroid[i].x -= 1;	
						aAsteroid[i].y += 1;
						break;
					case 4:
						aAsteroid[i].y += 2;
						break;
					case 5:
						aAsteroid[i].x += 1;	
						aAsteroid[i].y += 1;
						break;
					case 6:
						aAsteroid[i].x += 2;	
						break;
					case 7:	
						aAsteroid[i].x += 1;	
						aAsteroid[i].y -= 1;
						break;
					
				}
				gdiCircle(aAsteroid[i].x,aAsteroid[i].y, aAsteroid[i].radius, GDI_ROP_COPY);
				
				if(aAsteroid[i].x < 20){
					
					gdiBitBlt(NULL,aAsteroid[i].x-aAsteroid[i].radius,aAsteroid[i].y-aAsteroid[i].radius,(aAsteroid[i].radius *2) + 2,(aAsteroid[i].radius *2) + 2,(pu8) aAsteroid15,GDI_ROP_COPY);
					aAsteroid[i].x = 275;
				}
				if(aAsteroid[i].x > 280){
					
					gdiBitBlt(NULL,aAsteroid[i].x-aAsteroid[i].radius,aAsteroid[i].y-aAsteroid[i].radius,(aAsteroid[i].radius *2) + 2,(aAsteroid[i].radius *2) + 2,(pu8) aAsteroid15,GDI_ROP_COPY);
					aAsteroid[i].x = 25;
				}
				if(aAsteroid[i].y < 20){
					
					gdiBitBlt(NULL,aAsteroid[i].x-aAsteroid[i].radius,aAsteroid[i].y-aAsteroid[i].radius,(aAsteroid[i].radius *2) + 2,(aAsteroid[i].radius *2) + 2,(pu8) aAsteroid15,GDI_ROP_COPY);
					aAsteroid[i].y = 275;
				}
				if(aAsteroid[i].y > 280){
					
					gdiBitBlt(NULL,aAsteroid[i].x-aAsteroid[i].radius,aAsteroid[i].y-aAsteroid[i].radius,(aAsteroid[i].radius *2) + 2,(aAsteroid[i].radius *2) + 2,(pu8) aAsteroid15,GDI_ROP_COPY);
					aAsteroid[i].y = 25;
				}
				asteroidMoveRecently = 1;
				asteroidMoveStartTime = sysTicks;
				
				
				
				//Test if bomb touch asteroid

				if(siGoodBombActive == 1){
					if (siGoodBombX >= (aAsteroid[i].x - aAsteroid[i].radius*2 ) && siGoodBombX <= (aAsteroid[i].x + aAsteroid[i].radius*1.5)) {
						if (siGoodBombY <= (aAsteroid[i].y + aAsteroid[i].radius*1.5) && siGoodBombY >= (aAsteroid[i].y - aAsteroid[i].radius*1.6)) {
							
							gdiBitBlt(NULL,aAsteroid[i].x - aAsteroid[i].radius ,aAsteroid[i].y - aAsteroid[i].radius ,(aAsteroid[i].radius *2) + 2,(aAsteroid[i].radius *2) + 2,(pu8) aAsteroid15,GDI_ROP_COPY);
					//		gdiBitBlt(NULL,siGoodBombX,siGoodBombY,15,12,(pu8) siBadBoys99,GDI_ROP_COPY);
							gdiBitBlt(NULL,siGoodBombX,siGoodBombY,8,8,(pu8) siGoodBomb2,GDI_ROP_COPY);
							siGoodBombActive = 0;
							--aAsteroidCount;
							
							switch(aAsteroid[i].radius){
								case 15:
									siCurrentScore += 30;
									break;
								case 10:
									siCurrentScore += 20;
									break;
								case 5:
									siCurrentScore += 10;
									break;
								}
							aAsteroid[i].mode = 0;
							aCreateNewAsteroid(i);
							
						}
					}
				}

				
				//check if Asteroid hits player
			
				if (siXGoodBoy >= (aAsteroid[i].x - aAsteroid[i].radius*1.5 ) && siXGoodBoy <= (aAsteroid[i].x + aAsteroid[i].radius)) {
					if (siYGoodBoy <= (aAsteroid[i].y + aAsteroid[i].radius) && siYGoodBoy >= (aAsteroid[i].y - aAsteroid[i].radius *1.5)) {
						gdiBitBlt(NULL,aAsteroid[i].x - aAsteroid[i].radius ,aAsteroid[i].y - aAsteroid[i].radius ,(aAsteroid[i].radius *2) + 2,(aAsteroid[i].radius *2) + 2,(pu8) aAsteroid15,GDI_ROP_COPY);
								
						if (--siGoodBoyCount == 0) {	// Game over
							return;
						} else {
							while(1){
								if(aAsteroid[i].x >= 140 && aAsteroid[i].x <= 160){
									if(aAsteroid[i].y >= 140 && aAsteroid[i].y <= 160){
										aAsteroid[i].x = rand() % 250;
										aAsteroid[i].y = rand() % 250;
									}else{
										break;
									}
								}else{
									break;
								}
							}
							gdiBitBlt(NULL,siXGoodBoy,siYGoodBoy,16,16,(pu8) siGoodBoysBlk,GDI_ROP_COPY);
							siXGoodBoy = 150;
							siYGoodBoy = 150;
							siXGoodBoyV = 0;
							siYGoodBoyV = 0;
						}
					}
				}
			
			
			}
		}
		
	}	
	if(asteroidMoveRecently == 1){
		asteroidMoveTimer = sysTicks - asteroidMoveStartTime;
		if(asteroidMoveTimer >= 100){
			asteroidMoveRecently = 0;
			asteroidMoveTimer = 0.0;
			asteroidMoveStartTime = 0.0;
		}
	}
	
	
	
}




i16 playerDirection = 0;
volatile float changeStartTime = 0.0;
volatile float changeTimer = 0.0;
volatile int changeRecently = 0;

volatile float moveStartTime = 0.0;
volatile float moveTimer = 0.0;
volatile int moveRecently = 0;

volatile float shipMoveTimer;
volatile float shipMoveStartTime;
volatile int shipMoveRecently;

CCM void siMoveGoodBoys(void) {

	if (--siGoodBoysKeyDelay > 0) return;
	siGoodBoysKeyDelay = SI_GOODBOYSKEYDELAY;
	Demo_CompassReadAcc(AccBuffer);
	int x=(int)AccBuffer[0];
	int y=(int)AccBuffer[1];
	int z=(int)AccBuffer[2];



	GPIOE->ODR &= 0x00ff;

	
	
	if (x<-200) {
		
			GPIOE->ODR |= 1 << (5 +8);
			if(moveRecently == 0){
				switch(playerDirection){
					case 0:
						siYGoodBoyV -= 2;
						if(siXGoodBoyV > 1)siXGoodBoyV = 1;
						if(siXGoodBoyV < -1)siXGoodBoyV = -1;
						break;
					case 1:
						siXGoodBoyV -= 1;
						siYGoodBoyV -= 1;
						if(siXGoodBoyV < -1)siXGoodBoyV = -1;
						if(siYGoodBoyV < -1)siYGoodBoyV = -1;
						break;
					case 2:
						siXGoodBoyV -= 2;
						if(siYGoodBoyV > 1)siYGoodBoyV = 1;
						if(siYGoodBoyV < -1)siYGoodBoyV = -1;
						break;
					case 3:
						siXGoodBoyV -= 1;
						siYGoodBoyV += 1;
						if(siXGoodBoyV < -1)siXGoodBoyV = -1;
						if(siYGoodBoyV > 1)siYGoodBoyV = 1;
						break;
					case 4:
						siYGoodBoyV += 2;
						if(siXGoodBoyV > 1)siXGoodBoyV = 1;
						if(siXGoodBoyV < -1)siXGoodBoyV = -1;
						break;
					case 5:
						siXGoodBoyV += 1;
						siYGoodBoyV += 1;
						if(siXGoodBoyV > 1)siXGoodBoyV = 1;
						if(siYGoodBoyV > 1)siYGoodBoyV = 1;
						break;
					case 6:
						siXGoodBoyV += 2;
						if(siYGoodBoyV > 1)siYGoodBoyV = 1;
						if(siYGoodBoyV < -1)siYGoodBoyV = -1;
						break;
					case 7:
						siXGoodBoyV += 1;
						siYGoodBoyV -= 1;
						if(siXGoodBoyV > 1)siXGoodBoyV = 1;
						if(siYGoodBoyV < -1)siYGoodBoyV = -1;
						break;
				}
				moveRecently = 1;
				moveStartTime = sysTicks;
			}
			
			if(siXGoodBoyV > 2)siXGoodBoyV = 2;
				if(siXGoodBoyV < -2)siXGoodBoyV = -2;
				if(siYGoodBoyV > 2)siYGoodBoyV = 2;
				if(siYGoodBoyV < -2)siYGoodBoyV = -2;
		
			
			
		if(moveRecently == 1){
			moveTimer = sysTicks - moveStartTime;
			if(moveTimer >= 1000){
				moveRecently = 0;
				moveTimer = 0.0;
				moveStartTime = 0.0;
			}
		}
			
			
		
	}

	if (x>200) {
		if (siYGoodBoy < 285) {
			GPIOE->ODR |= 1 << (1 + 8);
			//down
		}
	}
	

	if (y<-400) {
		if (siXGoodBoy > 8) {
			
			GPIOE->ODR |= 1 << (3 +8);
			//siXGoodBoy -= 2;
			if(changeRecently == 0){
				if(playerDirection == 7){
					playerDirection = 0;
				}else{
					playerDirection++;
				}
				changeStartTime = sysTicks;
				changeRecently = 1;
			}
		}
	}
	
	if (y>400) {
		if (siXGoodBoy < 290) {
			GPIOE->ODR |= 1 << (7 + 8);
			//siXGoodBoy += 2;
			if(changeRecently == 0){
				if(playerDirection == 0){
					playerDirection = 7;
				}else{
					playerDirection--;
				}
				changeStartTime = sysTicks;
				changeRecently = 1;
			}
		}
	}
		
	if(shipMoveRecently == 0){
		siXGoodBoy += siXGoodBoyV;
		siYGoodBoy += siYGoodBoyV;
		shipMoveRecently = 1;
		shipMoveStartTime = sysTicks;
	}
		
	switch(playerDirection){
					case 0:
						gdiBitBlt(NULL,siXGoodBoy,siYGoodBoy,16,16,(pu8) siGoodBoysU,GDI_ROP_COPY);
						break;
					case 1:
						gdiBitBlt(NULL,siXGoodBoy,siYGoodBoy,16,16,(pu8) siGoodBoysUL,GDI_ROP_COPY);
						break;
					case 2:
						gdiBitBlt(NULL,siXGoodBoy,siYGoodBoy,16,16,(pu8) siGoodBoysL,GDI_ROP_COPY);
						break;
					case 3:
						gdiBitBlt(NULL,siXGoodBoy,siYGoodBoy,16,16,(pu8) siGoodBoysDL,GDI_ROP_COPY);
						break;
					case 4:
						gdiBitBlt(NULL,siXGoodBoy,siYGoodBoy,16,16,(pu8) siGoodBoysD,GDI_ROP_COPY);
						break;
					case 5:
						gdiBitBlt(NULL,siXGoodBoy,siYGoodBoy,16,16,(pu8) siGoodBoysDR,GDI_ROP_COPY);
						break;
					case 6:
						gdiBitBlt(NULL,siXGoodBoy,siYGoodBoy,16,16,(pu8) siGoodBoysR,GDI_ROP_COPY);
						break;
					case 7:
						gdiBitBlt(NULL,siXGoodBoy,siYGoodBoy,16,16,(pu8) siGoodBoysUR,GDI_ROP_COPY);
						break;
		}
	
		if (siYGoodBoy <= 5 ) {
			gdiBitBlt(NULL,siXGoodBoy,siYGoodBoy,16,16,(pu8) siGoodBoysBlk,GDI_ROP_COPY);
			siYGoodBoy = 281;
		}else if(siYGoodBoy >= 283){
			gdiBitBlt(NULL,siXGoodBoy,siYGoodBoy,16,16,(pu8) siGoodBoysBlk,GDI_ROP_COPY);
			siYGoodBoy = 7;
		}
		if (siXGoodBoy <= 5 ) {
			gdiBitBlt(NULL,siXGoodBoy,siYGoodBoy,16,16,(pu8) siGoodBoysBlk,GDI_ROP_COPY);
			siXGoodBoy = 281;
		}else if(siXGoodBoy >= 283){
			gdiBitBlt(NULL,siXGoodBoy,siYGoodBoy,16,16,(pu8) siGoodBoysBlk,GDI_ROP_COPY);
			siXGoodBoy = 7;
		}
	
	if(changeRecently == 1){
		GPIOE->ODR |= 1 << (2 + 8);
		changeTimer = sysTicks - changeStartTime;
		if(changeTimer >= 500){
			changeRecently = 0;
			changeTimer = 0.0;
			changeStartTime = 0.0;
		}
	}
	
		if(shipMoveRecently == 1){
		shipMoveTimer = sysTicks - shipMoveStartTime;
		if(shipMoveTimer >= 10){
			shipMoveRecently = 0;
			shipMoveTimer = 0.0;
			shipMoveStartTime = 0.0;
		}
	}
	
	


}

CCM void siMoveGoodBomb(void) {

i16		d, i, n;

	if (!siGoodBombActive) return;
	if (--siGoodBombDelay > 0) return;
	siGoodBombDelay = SI_GOODBOMBDELAY;

	gdiBitBlt(NULL,siGoodBombX,siGoodBombY,8,7,(pu8) siGoodBomb2,GDI_ROP_COPY);



	switch(siGoodBombDirection){
		case 0:
			siGoodBombY -= 2;
			break;
		case 1:
			siGoodBombY -= 1;
			siGoodBombX -= 1;
			break;
		case 2:
			siGoodBombX -= 2;
			break;
		case 3:
			siGoodBombY += 1;
			siGoodBombX -= 1;
			break;
		case 4:
			siGoodBombY += 2;
			break;
		case 5:
			siGoodBombY += 1;
			siGoodBombX += 1;
			break;
		case 6:
			siGoodBombX += 2;
			break;
		case 7:
			siGoodBombX += 1;
			siGoodBombY -= 1;
			break;	
		
		
		
	}
	if(siGoodBombActive) gdiBitBlt(NULL,siGoodBombX,siGoodBombY,8,7,(pu8) siGoodBomb1,GDI_ROP_COPY);

	if (siGoodBombY < 5 || siGoodBombY > 285 || siGoodBombX < 5 || siGoodBombX > 305) {
		gdiBitBlt(NULL,siGoodBombX,siGoodBombY,8,8,(pu8) siGoodBomb2,GDI_ROP_COPY);
		siGoodBombActive = 0;
	} 
}

void siGoodBombStart(void) {

	if ((GPIOA->IDR & SI_FIRE_BUTTON) == 0) {
		if (siGoodBombKeyState == 0 && siGoodBombActive == 0) {
			siGoodBombDirection = playerDirection;
			siGoodBombActive = 1;
			siGoodBombKeyState = 1;
			
			switch(playerDirection){
				case 0:
					siGoodBombY =  siYGoodBoy;
					siGoodBombX = siXGoodBoy + 6;
					break;
				case 1:
					siGoodBombY =  siYGoodBoy ;
					siGoodBombX = siXGoodBoy + 1;
					break;
				case 2:
					siGoodBombY =  siYGoodBoy + 5 ;
					siGoodBombX = siXGoodBoy + 1;
					break;
				case 3:
					siGoodBombY =  siYGoodBoy +9;
					siGoodBombX = siXGoodBoy ;
					break;
				case 4:
					siGoodBombY =  siYGoodBoy + 10;
					siGoodBombX = siXGoodBoy + 7;
					break;
				case 5:
					siGoodBombY =  siYGoodBoy + 9;
					siGoodBombX = siXGoodBoy + 11;
					break;
				case 6:
					siGoodBombY =  siYGoodBoy + 5;
					siGoodBombX = siXGoodBoy + 10;
					break;
				case 7:
					siGoodBombY =  siYGoodBoy ;
					siGoodBombX = siXGoodBoy + 11; 
					break;
			}
		}
	} else {
		siGoodBombKeyState = 0;
	}

}


void numtostr(char *buffer,int n) {
int i = 0;
int isNeg = n<0;
unsigned int n1 = isNeg ? -n : n;
int t;

while(n1!=0)
{
    buffer[i++] = n1%10+'0';
    n1=n1/10;
}

if(isNeg)
    buffer[i++] = '-';

buffer[i] = '\0';

for(t = 0; t < i/2; t++)
{
    buffer[t] ^= buffer[i-t-1];
    buffer[i-t-1] ^= buffer[t];
    buffer[t] ^= buffer[i-t-1];
}

if(n == 0)
{
    buffer[0] = '0';
    buffer[1] = '\0';
}
}

CCM void aEndOfLevel(void){
	i16		i, x, t;
		for (t = 0; t < 4; t++) {
			x = 322;
			for (i = 1; i < SI_MAXGOODBOYS; i++) {
				gdiBitBlt(NULL,x,SI_GOODBOYSTART_Y,16,16,(pu8) siGoodBoysBlk,GDI_ROP_COPY);
				x += 24;
			}
			sysDelayMs(200);
			x = 322;
			for (i = 1; i < SI_MAXGOODBOYS; i++) {
				if (i < siGoodBoyCount) {
					gdiBitBlt(NULL,x,SI_GOODBOYSTART_Y,16,16,(pu8) siGoodBoys,GDI_ROP_COPY);
				} else {
					gdiBitBlt(NULL,x,SI_GOODBOYSTART_Y,16,16,(pu8) siGoodBoysBlk,GDI_ROP_COPY);
				}
				x += 24;
			}
			sysDelayMs(300);
		}
	gdiBitBlt(NULL,siXGoodBoy,siYGoodBoy,16,16,(pu8) siGoodBoysBlk,GDI_ROP_COPY);
	siXGoodBoy = 150;
	siYGoodBoy = 150;
	siXGoodBoyV = 0;
	siYGoodBoyV = 0;
	aAsteroid[0].mode = 1;
	aAsteroid[0].radius = 15;
	aAsteroid[0].x = rand() % 250;
	aAsteroid[0].y = rand() % 250;
	aAsteroid[0].direction = rand() % 8;
	aAsteroid[4].mode = 1;
	aAsteroid[4].radius = 15;
	aAsteroid[4].x = rand() % 250;
	aAsteroid[4].y = rand() % 250;
	aAsteroid[4].direction = rand() % 8;
	if(aLevel == 1){
		for(int j = 0; j <= 4; j += 4){
			if(aAsteroid[i].x >= 140 && aAsteroid[i].x <= 160){
				if(aAsteroid[i].y >= 140 && aAsteroid[i].y <= 160){
					aAsteroid[i].x = rand() % 250;
					aAsteroid[i].y = rand() % 250;
				}
			}
		}
	}else{
		for(int j = 0; j <= 8; j += 4){
			if(aAsteroid[i].x >= 140 && aAsteroid[i].x <= 160){
				if(aAsteroid[i].y >= 140 && aAsteroid[i].y <= 160){
					aAsteroid[i].x = rand() % 250;
					aAsteroid[i].y = rand() % 250;
				}
			}
		}
		aAsteroid[8].mode = 1;
		aAsteroid[8].radius = 15;
		aAsteroid[8].x = rand() % 250;
		aAsteroid[8].y = rand() % 250;
		aAsteroid[8].direction = rand() % 8;
	}
	aLevel++;
	
	
}

CCM void siDrawGoodBoyLeft(void) {

i16		i, x, t;

	if (siGoodBoyCount != siGoodBoyCountOld) {
		strcpy((char*) siScore,"LEFT: ");
		numtostr(siScore+6,siGoodBoyCount - 1);
//		sprintf((char*) siScore,"LEFT: %d",siGoodBoyCount - 1);
		gdiDrawTextEx(340,170,siScore,GDI_ROP_COPY);

		siGoodBoyCountOld = siGoodBoyCount;
		for (t = 0; t < 4; t++) {
			x = 322;
			for (i = 1; i < SI_MAXGOODBOYS; i++) {
				gdiBitBlt(NULL,x,SI_GOODBOYSTART_Y,16,16,(pu8) siGoodBoysBlk,GDI_ROP_COPY);
				x += 24;
			}
			sysDelayMs(200);
			x = 322;
			for (i = 1; i < SI_MAXGOODBOYS; i++) {
				if (i < siGoodBoyCount) {
					gdiBitBlt(NULL,x,SI_GOODBOYSTART_Y,16,16,(pu8) siGoodBoys,GDI_ROP_COPY);
				} else {
					gdiBitBlt(NULL,x,SI_GOODBOYSTART_Y,16,16,(pu8) siGoodBoysBlk,GDI_ROP_COPY);
				}
				x += 24;
			}
			sysDelayMs(300);
		}
		siXGoodBoy = SI_GOODBOYSTART_X;
		gdiBitBlt(NULL,siXGoodBoy,siYGoodBoy,16,16,(pu8) siGoodBoys,GDI_ROP_COPY);
	}
}



//	The game

void siTheGame(void) {

	while(1) {

		sysDelayMs(1);
		

		aMoveAsteroid();
		
		siDrawGoodBoyLeft();
		siMoveGoodBoys();
		siGoodBombStart();
		siMoveGoodBomb();
		
		
		if(aAsteroidCount == 0){
			
			switch(aLevel){
				case 1:
					aEndOfLevel();
					aAsteroidCount = 2;
					break;
				case 2:
					aEndOfLevel();
					aAsteroidCount = 3;
					break;
				case 3:
					siYouWin();
					return;	
					break;
			}
			
	
			
			
		}
		if (siGoodBoyCount == 0) {	// Game over
			siYouLose();
			return;
		}

		if (siBakScore != siCurrentScore) {
			siBakScore = siCurrentScore;
			strcpy((char*) siScore,"SCORE: ");
                	numtostr(siScore+7,siCurrentScore);
            gdiDrawTextEx(328,20,siScore,GDI_ROP_COPY);

			strcpy((char*) siScore,"LEVEL: ");
			numtostr(siScore+6,aLevel);
			gdiDrawTextEx(328,38,siScore,GDI_ROP_COPY);
			
			strcpy((char*) siScore,"REMAINING: ");
			numtostr(siScore+10,aAsteroidCount);
			gdiDrawTextEx(328,47,siScore,GDI_ROP_COPY);

			
			strcpy((char*) siScore,"BEST: ");
			numtostr(siScore+6,siBestScore);
			gdiDrawTextEx(328,29,siScore,GDI_ROP_COPY);
			
			
		}
	}
}


//*****************************************************************************
//	Function siInit
//
//	Init Asteroid
//
//	return			none
//*****************************************************************************
void siInit(void) {

GPIO_InitTypeDef	GPIO_InitStructure;
u16					i, n, j, x, y;

//	Configure button pins

	GPIO_InitStructure.GPIO_Pin = SI_FIRE_BUTTON | SI_LEFT_BUTTON | SI_RIGHT_BUTTON;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(GPIOA, &GPIO_InitStructure);

	//gdiBitBlt(NULL,0,0,(VID_PIXELS_X - 1),232,(pu8) siLogo,0);
	//sysDelayMs(5000);

	Demo_CompassConfig();

start:

	siInitialScreen();

	vidClearScreen();
	gdiRectangle(0,0,(VID_PIXELS_X - 1),VID_VSIZE - 1,0);
	gdiLine(NULL,320,0,320,VID_VSIZE,GDI_ROP_COPY);

	aLevel = 1;
	
//  Preload Asteroids
	for(int i = 0; i < aLevel * 4 ; i++){
		aAsteroid[i].x = rand() % 250;
		aAsteroid[i].y = rand() % 250;
		aAsteroid[i].radius = 15;
		aAsteroid[i].direction = rand() % 8;
		aAsteroid[i].mode = 0;
	}
		
		
	
		aAsteroid[0].mode = 1;
		aAsteroid[4].mode = 1;
		aAsteroid[8].mode = 1;
		
		aAsteroidCount = 1;
	

//	Init default variables

	siXGoodBoy = SI_GOODBOYSTART_X;
	siYGoodBoy = SI_GOODBOYSTART_Y;


	siGoodBoysKeyDelay = SI_GOODBOYSKEYDELAY;
	siGoodBombDelay = SI_GOODBOMBDELAY;
	if (siCurrentScore > siBestScore) siBestScore = siCurrentScore;
	siCurrentScore = 0;

	siBakScore = -1;
	siGoodBoyCount = SI_MAXGOODBOYS;
	siGoodBoyCountOld = 0;
	
	
//	Show Good Boy first time

	gdiBitBlt(NULL,siXGoodBoy,siYGoodBoy,16,16,(pu8) siGoodBoys,GDI_ROP_COPY);

//	Show Asteroids first time

	for(int i = 0; i < aLevel * 4;i++){
		if(aAsteroid[i].mode == 1){
			gdiCircle(aAsteroid[i].x,aAsteroid[i].y, aAsteroid[i].radius, GDI_ROP_COPY);
		}
	}
	
//	Start Gane

	siTheGame();
	goto start;
}	


