/* BLE/UART Cows tracker communication module
 *
 * author    : Dawid Zalewski
 * date      : 16-10-2018
 * platforms : rRF52-DK
 *
 */

/* mbed platform defines */
#include <events/mbed_events.h>
#include <mbed.h>
#include "Serial.h"

// Some ugly redefines to get things working
#define RESET_PIN (P0_21)
#define CUSTOM_LED (P0_25)
#define CUSTOM_TX (P0_06)
#define CUSTOM_RX (P0_08)
#define UART_BAUDRATE ( 115200 )

static mbed::Serial *serialPtr;

DigitalOut led1(CUSTOM_LED, 1);

// apparently needed
EventQueue eventQueue(16 * EVENTS_EVENT_SIZE);


// UART thingies begin here
#define UART_RX_BUFFER_LEN (256)
static uint8_t uartReceiveBuffer[UART_RX_BUFFER_LEN];
static uint8_t uartRxLen = 0;

void onUartDataWritten();

void handleUartDataWritten( ){
    
    while( serialPtr->readable() ){
        
        //read all that is available
        serialPtr->putc('<');

        while( serialPtr->readable() && (uartRxLen < UART_RX_BUFFER_LEN )){
            serialPtr->putc(serialPtr->getc());    
        }
                
        serialPtr->putc('>');
    }
    serialPtr->attach(onUartDataWritten, Serial::RxIrq);
}

void onUartDataWritten(){
    serialPtr->attach(NULL, Serial::RxIrq);
    eventQueue.call(handleUartDataWritten);
}

void initUart(){
    serialPtr = new Serial(USBTX, USBRX, UART_BAUDRATE);
    serialPtr->attach(&onUartDataWritten, Serial::RxIrq);
}

void blinker(void)
{
    led1 = !led1;
}

int main(){
    eventQueue.call_every(250, blinker);
    initUart();
    eventQueue.dispatch_forever();    
    return 0;
}