#include "mbed.h"
#include "DHT.h"

DigitalOut myled(LED1);
DigitalInOut data_pin(A0); // Activate digital in
DigitalInOut data_pin(A1); // Activate digital in
Serial pc(SERIAL_TX, SERIAL_RX); // Initialize UART connection
Serial blutooth(PA_9, PA_10);//Tx, Rx
Timer tmr; //initialize timer
uint64_t adat; // 64 bit variable for temporary data
int i;

// Use a terminal program (eg. TeraTerm).
//Timer tmr; //initialize timer


DHT sensor(A0,SEN11301P); // Use the SEN11301P sensor

int main() {
    int err;
    pc.printf("\r\nDHT Test program");
    pc.printf("\r\n******************\r\n");
    wait(1); // wait 1 second for device stable status
    while (1) {
        myled = 1;
        wait(2);
        err = sensor.readData();
        if (err == 0) {
            
            pc.printf("Temperature is %4.2f C \r\n",sensor.ReadTemperature(CELCIUS));
            pc.printf("Temperature is %4.2f F \r\n",sensor.ReadTemperature(FARENHEIT));
            pc.printf("Temperature is %4.2f K \r\n",sensor.ReadTemperature(KELVIN));
            pc.printf("Humidity is %4.2f \r\n",sensor.ReadHumidity());
            pc.printf("Dew point is %4.2f \r\n",sensor.CalcdewPoint(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
            pc.printf("Dew point (fast) is %4.2f  \r\n",sensor.CalcdewPointFast(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
            pc.printf("\n\n\n");
        } else
            pc.printf("\r\nErr %i \n",err);
        myled = 0;
        wait(5);
    }
}