#include "mbed.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"

#define USR_POWERDOWN    (0x104)

int semihost_powerdown() {
    uint32_t arg;
    return __semihost(USR_POWERDOWN, &arg); 
}

DigitalOut myled(LED1);
DigitalOut result(LED2);

int main() {
     wait(2);
     // Turn off all peripherals
     Peripheral_PowerDown(LPC1768_PCONP_PCTIM0);
     Peripheral_PowerDown(LPC1768_PCONP_PCTIM1);
     Peripheral_PowerDown(LPC1768_PCONP_PCUART0);
     Peripheral_PowerDown(LPC1768_PCONP_PCUART1);
     Peripheral_PowerDown(LPC1768_PCONP_PCPWM1);
     Peripheral_PowerDown(LPC1768_PCONP_PCI2C0);
     Peripheral_PowerDown(LPC1768_PCONP_PCSPI);
     Peripheral_PowerDown(LPC1768_PCONP_PCRTC);
     Peripheral_PowerDown(LPC1768_PCONP_PCSSP1);
     Peripheral_PowerDown(LPC1768_PCONP_PCADC);
     Peripheral_PowerDown(LPC1768_PCONP_PCGPIO);
     Peripheral_PowerDown(LPC1768_PCONP_PCRIT);
     Peripheral_PowerDown(LPC1768_PCONP_PCMCPWM);
     Peripheral_PowerDown(LPC1768_PCONP_PCQEI);
     Peripheral_PowerDown(LPC1768_PCONP_PCI2C1);
     Peripheral_PowerDown(LPC1768_PCONP_PCSSP0);
     Peripheral_PowerDown(LPC1768_PCONP_PCTIM2);
     // TIMER 3 not turned off
     //Peripheral_PowerDown(LPC1768_PCONP_PCQTIM3);
     Peripheral_PowerDown(LPC1768_PCONP_PCUART2);
     Peripheral_PowerDown(LPC1768_PCONP_PCUART3);
     Peripheral_PowerDown(LPC1768_PCONP_PCI2C2);
     Peripheral_PowerDown(LPC1768_PCONP_PCI2S);
     Peripheral_PowerDown(LPC1768_PCONP_PCGPDMA);
     Peripheral_PowerDown(LPC1768_PCONP_PCENET);
     Peripheral_PowerDown(LPC1768_PCONP_PCUSB);     
     wait(2);
     // Turn off PHY
     PHY_PowerDown();
     wait(2);
     // Turn off IF
     result = semihost_powerdown();   
     wait(2);
     // Go to Sleep
     DeepPowerDown();
}