#include "DebouncedIn.h"
#include "mbed.h"

/*
 * Constructor
 */
DebouncedIn::DebouncedIn(PinName in) 
    : _in(in) {    
        
    // reset all the flags and counters    
    _samples = 0;
    _output = 0;
    _output_last = 0;
    _releasing_flag = 0;
    _pressing_flag = 0;
    _press_counter = 0;
    
    // Switch is assumed to go to ground 
    _in.mode(PullUp);
    
    // Attach ticker
    _ticker.attach(this, &DebouncedIn::_sample, 0.005);     
}
  
void DebouncedIn::_sample() {

    // take a sample
    _samples = _samples >> 1; // shift left
      
    if (_in) {
        _samples |= 0x80;
    }  
      
    // examine the sample window, look for steady state
    if (_samples == 0x00) {
        _output = 0;
    } 
    else if (_samples == 0xFF) {
        _output = 1;
    }


    // Release detection
    if ((_output == 1) && (_output_last == 0)) {
        _releasing_flag++;
    }

    // Press detection
    else if ((_output == 0) && (_output_last == 1)) {
        _pressing_flag++;
        _press_counter = 0;
    }
    
    // pressed state
    else if (_output == 0) {
        _press_counter++;
    }
    
   // update the output
    _output_last = _output;
    
    //printf("%d %d\n", _press_counter, _releasing_flag);
}



// return number of releasing events
int DebouncedIn::releasing(void) {
    int return_value = _releasing_flag; 
    _releasing_flag = 0;
    return(return_value);
}

// return number of pressing events
int DebouncedIn::pressing(void) {
    int return_value = _pressing_flag; 
    _pressing_flag = 0;
    return(return_value);
}

// return number of ticks we've bene steady for
int DebouncedIn::pressed(void) {
return(_press_counter);
}

// return the debounced status
int DebouncedIn::read(void) {
    return(_output);
}

// shorthand for read()
DebouncedIn::operator int() {
    return read();
}


