#include "mbed.h"
#include "EthernetInterface.h"

#define XI_FEED_ID 1344466483 // set Xively Feed ID (numerical, no quoutes)
#define XI_API_KEY "mgjx3VwlsvsMBhekqcASRLnzMPHi9Aw2gZCZCzyH0vQkefn3" // set Xively API key (double-quoted string)

#include "app_board_io.h"

#include "xively.h"
#include "xi_err.h"

#include "MMA7660.h"
#include "LM75B.h"
#include "C12832_lcd.h"
#define ECHO_SERVER_PORT   7
MMA7660 axl(p28, p27);
//LM75B tmp(p28, p27);
AnalogIn tmp(p19);
C12832_LCD lcd;
DigitalOut cL(LED1);
Serial pc(USBTX,USBRX);
#include "logo.h"

int main() {
    cL = 1;
    /*lcd_print_xively_logo();*/
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    pc.printf("IP Address is %s\n", eth.getIPAddress());
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    while (true) {
        pc.printf("\nWait for new connection...\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 150000); // Timeout after (1.5)s
        
        pc.printf("Connection from: %s\n", client.get_address());
        char buffer[256];
        while (true) {
            //int n = client.receive(buffer, sizeof(buffer));
            //if (n <= 0) break;
            
            //client.send_all(buffer, n);
            //if (n <= 0) break;
              
    pc.printf("Received:%s", buffer);
    
    xi_feed_t feed;
    memset( &feed, NULL, sizeof( xi_feed_t ) );
    
    feed.feed_id = XI_FEED_ID;
    feed.datastream_count = 4;
    
    feed.datastreams[0].datapoint_count = 1;
    xi_datastream_t* orientation_datastream = &feed.datastreams[0];
    strcpy( orientation_datastream->datastream_id, "orientation" );
    xi_datapoint_t* current_orientation = &orientation_datastream->datapoints[0];

    feed.datastreams[1].datapoint_count = 1;
    xi_datastream_t* side_rotation_datastream = &feed.datastreams[1];
    strcpy( side_rotation_datastream->datastream_id, "side_rotation" );
    xi_datapoint_t* current_side_rotation = &side_rotation_datastream->datapoints[0];
    
    feed.datastreams[2].datapoint_count = 1;
    xi_datastream_t* temperature_datastream = &feed.datastreams[2];
    strcpy( temperature_datastream->datastream_id, "temperature" );
    xi_datapoint_t* current_temperature = &temperature_datastream->datapoints[0];
    
    feed.datastreams[3].datapoint_count = 1;
    xi_datastream_t* control_datastream = &feed.datastreams[3];
    strcpy( control_datastream->datastream_id, "System" );
    xi_datapoint_t* current_state = &control_datastream->datapoints[0];
    
    // create the cosm library context
    xi_context_t* xi_context = xi_create_context( XI_HTTP, XI_API_KEY, feed.feed_id );

    // check if everything works
    if( xi_context == NULL )
    {
        return -1;
    }

    
      
      switch( axl.getSide() ) {
        case MMA7660::Front:
          xi_set_value_str( current_side_rotation, "front" );
          break;
        case MMA7660::Back:
          xi_set_value_str( current_side_rotation, "back" );
          break;
        default:
          xi_set_value_str( current_side_rotation, "unknown" );
          break;
      }
      
      switch( axl.getOrientation() ) {
        case MMA7660::Down:
          xi_set_value_str( current_orientation, "down" );
          break;
        case MMA7660::Up:
           xi_set_value_str( current_orientation, "up" );
           break;
        case MMA7660::Right:
          xi_set_value_str( current_orientation, "right" );
          break;
        case MMA7660::Left:
          xi_set_value_str( current_orientation, "left" );
          break;
        default: 
          xi_set_value_str( current_orientation, "unknown" );
          break;
      }
      
       xi_set_value_f32( current_temperature, tmp.read() );
       xi_datastream_get( xi_context, feed.feed_id
                    , control_datastream->datastream_id
                    , control_datastream->datapoints);      
                        current_state = &control_datastream->datapoints[0];   
      int system_status = current_state->value.i32_value;
      
      if (system_status == 0)
       {
           cL = 0;
        }
      if (system_status == 1)
       {
           cL = 1;
        }
        
      lcd_printf( "update...\n" );
      xi_feed_update( xi_context, &feed );
      lcd_printf( "done...\n" );
      
      
      }
        client.close();
        
 }
   
}
