#include "mbed.h"
#include "BNO055.h"

#define SENSOR_9D0F_ADDR    (0x28 << 1) // 9D0F address
#define CHIP_ID_REG         (0x0)       // Chip ID (regval = 8'b10100000 == 0xA)
// I2C i2c(I2C_SDA, I2C_SCL);

BNO055 sensor_9D0F = BNO055(I2C_SDA, I2C_SCL);
 
Serial pc(SERIAL_TX, SERIAL_RX);
 
int main()
{
    // Ping 9D0F sensor
    if( !sensor_9D0F.check() )  //read returns 0 on ACK
    {
        pc.printf("I2C Failed to 9D0F sensor");
    } 
    else
    {
        pc.printf("I2C connection established with 9D0F");
    }
    sensor_9D0F.setmode(OPERATION_MODE_ACCONLY);
    
    while (1) {
        sensor_9D0F.get_accel();
        printf( " Accel x (raw): %d\n Accel y (raw): %d\n Accel z (raw): %d\n Accel x (scaled): %f\n Accel y (scaled): %f\n Accel z (scaled): %f\n",
                 sensor_9D0F.accel.rawx, sensor_9D0F.accel.rawy, sensor_9D0F.accel.rawz, 
                 sensor_9D0F.accel.x, sensor_9D0F.accel.y, sensor_9D0F.accel.z);
        
        wait(0.25);
    }
 
}
 
