#ifndef GAMEENGINE_H
#define GAMEENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Coin.h"
#include "Bag.h"

/** GameEngine Class
* @brief Judge the situation of adding score or gameover
* @author Zikang Qian
* @date April, 2018
*/

class GameEngine
{

public:

    /** Constructor */
    GameEngine();
    
    /** Destructor */
    ~GameEngine();
    
    /** Initiate the bag size, coin size and speed
     * @param the value of the bag width (int),bag height (int),coin size (int) and speed (int)
     */
    void init(int bag_width,int bag_height,int coin_size,int speed);
    
    /** Get the input information from the gamepad
     * @param the input of gamepad (pad)
     */
    void read_input(Gamepad &pad);
    
    /** Output the information from the gamepad
     * @return the input of gamepad (pad)
     */
    int update(Gamepad &pad);
    
    /** Show both bag and coin figure on screen
     * @param the figrue (lcd)
     */
    void draw(N5110 &lcd);
    
private:

    /** Add score case 
     * @param input of gamepad (pad)
     */
    void check_bag_collisions(Gamepad &pad);
    
    /** Game over case 
     * @param input of gamepad (pad)
     */
    void game_over(Gamepad &pad);
    
    /** Game over case 
     * @param input of gamepad (pad)
     */
    void print_scores(N5110 &lcd);
    
    Bag _bag;
    Coin _coin;  
    Direction _direction;
     
    int _bag_width;
    int _bag_height;
    int _coin_size;
    int _speed;
    int _py;
    float _mag;
    
    int gameover;

};

#endif