#include "GameEngine.h"

GameEngine::GameEngine()
{

}

GameEngine::~GameEngine()
{

}

void GameEngine::init(int bag_width,int bag_height,int coin_size,int speed)
{
    // initialise the game parameters
    _bag_width = bag_width;
    _bag_height = bag_height;
    _coin_size = coin_size;
    _speed = speed;

    // y position on screen - HEIGHT is defined in N5110.h
    _py = HEIGHT  - _bag_height;

    // puts bag in middle
    _bag.init(_py,_bag_height,_bag_width);
    
    // puts coin in random place
    _coin.init(_coin_size,_speed);
}

void GameEngine::read_input(Gamepad &pad)
{
    // get the input information from Gamepad
    _direction = pad.get_direction();
    _mag = pad.get_mag();
}

void GameEngine::draw(N5110 &lcd)
{
    // draw the elements in the LCD buffer
    // score
    print_scores(lcd);
    
    // bag
    _bag.draw(lcd);
    
    // coin
    _coin.draw(lcd);
}

int GameEngine::update(Gamepad &pad)
{
    // the situation whether continue or end game, 1 stand for continue and 0 stand for game over
    gameover = 1;
    
    // updating bag
    _bag.update(_direction,_mag);
    // updating coin
    _coin.update();
    
    // case for adding score
    check_bag_collisions(pad);
    // case for ending game
    game_over(pad);
    
    return gameover;
}

// add score case
void GameEngine::check_bag_collisions(Gamepad &pad)
{
    // get current coin attributes
    Vector2D coin_position = _coin.get_coin_position();
    // get current bag attributes
    Vector2D bag_position = _bag.get_bag_position();

    // see if bag has caught the coin by checking for overlap of coin and bag
      if  (
        (coin_position.y + _coin_size -5<= _py + _bag_height) && //top
        (coin_position.y + _coin_size -5>= _py) && //bottom
        (coin_position.x  >= bag_position.x -2) && //left
        (coin_position.x  <= bag_position.x + _bag_width +2)  //right
        ){ 
        // game continue and add score when "gameover" return 1
        gameover = 1;
        // adding score process
        _bag.add_score();
        
        // reset a new coin
        _coin.init(_coin_size,_speed);
        
        // audio feedback
        pad.tone(1000.0,0.5);
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        } 
}

// gameover case
void GameEngine::game_over(Gamepad &pad)
{
    // get current coin attributes
    Vector2D coin_position = _coin.get_coin_position();
    // get current bag attributes
    Vector2D bag_position = _bag.get_bag_position();
    
    // see if coin fall away by checking for overlap of coin and bottom boundary
     if (coin_position.y + _coin_size >= 48)
     {
        // game over when "gameover" return 0
        gameover = 0;
        
        // audio feedback
        pad.tone(1500.0,0.5);
        pad.leds_on();
        wait(0.5);
        pad.leds_off();
      }
}

void GameEngine::print_scores(N5110 &lcd)
{
    // get scores from bag
    int score = _bag.get_score();
    
    // get highest scores from bag
    int Hscore = _bag.get_Hscore();

    // print to LCD
    char buffer1[14];
    char buffer2[14];
    sprintf(buffer1,"%2d",score);
    sprintf(buffer2,"%2d",Hscore);
    
    // current score is shown on right top corner
    lcd.printString(buffer1,68,0); 
    
    // highest score is shown on right bottom corner
    lcd.printString("HS:",68,4); 
    lcd.printString(buffer2,68,5);
}
