#ifndef COINWITHBAG_TEST_H
#define COINWITHBAG_TEST_H

/** CoinWithBag-test Class
* @brief Check that the coin object correctly collides with the bag
* @author Zikang Qian
* @date April, 2018
*/

/** \returns true if all the tests passed
 */
bool CoinWithBag_test_collide()
{
    Coin coin;
    Bag bag;
    GameEngine game;
    
    // initial size of coin and bag
    coin.init(2.5,1);
    bag.init(17,2,1);
    game.init(17,2,2.5,1);

    // initial position of coin
    Vector2D initial_coin_position = {5, 0};
    coin.set_position(initial_coin_position);
    
    // initial position of bag, where below the coin
    Vector2D initial_bag_position = {3, 46};
    bag.set_position(initial_bag_position);

    // Read the position of coin
    Vector2D read_coin_position = coin.get_position();
    printf("%f, %f\n", read_coin_position.x, read_coin_position.y);
    
    // Read the position of bag
    Vector2D read_bag_position = bag.get_position();
    printf("%f, %f\n", read_bag_position.x, read_bag_position.y);

    // Set the velocity to 0,47 so that coin can collide with bag immediately
    Vector2D velocity = {0, 47};
    coin.set_velocity(velocity);

    // Update the coin and bag
    coin.update();
    bag.update();
    
    // get the result of colliding analysis
    int nodead = game.update(pad);
    
    bool success = true;
    
    // failed if game over
    if (nodead != 1) {
        success = false;
    }

    return success;
}

#endif