#ifndef COIN_TEST_H
#define COIN_TEST_H

/** Coin-test Class
* @brief Check that coin object goes to correct position when moved
* @author Zikang Qian
* @date April, 2018
*/

/** \returns true if all the tests passed
 */
bool Coin_test_movement()
{
    // Initialise Coin object with a size of 2.5, and speed of 1
    Coin coin;
    coin.init(2.5, 1);

    // Set the position to 5, 0
    Vector2D initial_position = {5, 0};
    coin.set_coin_position(initial_position);

    // Read the position
    Vector2D read_coin_position_1 = coin.get_coin_position();
    printf("%f, %f\n", read_coin_position_1.x, read_coin_position_1.y);

    // Set the velocity to 0, 3
    Vector2D velocity = {0, 3};
    coin.set_coin_velocity(velocity);

    // Update the position
    coin.update();

    // Read the position
    Vector2D read_coin_position_2 = coin.get_coin_position();
    printf("%f, %f\n", read_coin_position_2.x, read_coin_position_2.y);
    
    // Now check that both the positions are as expected
    bool success = true;
    
    // Fail the test if the initial position is wrong
    if (read_coin_position_1.x != 5 || read_coin_position_1.y != 0) {
        success = false;
    }
    
    // Fail the test if the final position is wrong
    if (read_coin_position_2.x != 5 || read_coin_position_2.y != 3) {
        success = false;
    }

    return success;
}
#endif