#ifndef TESTS_H
#define TESTS_H

#include "Coin-test.h"
#include "Hscore-test.h"
#include "CoinWithBag-test.h"
#include "CoinWithBoundary-test.h"

/**
 * @brief Run all the tests for this program
 *
 * @returns The number of tests that failed
 */
int run_all_tests()
{
    int n_tests_failed = 0; // A log of the number of tests that have failed

    // Run the Ball_test_movement test
    printf("Testing Coin_test_movement...\n");
    bool test1_passed = Coin_test_movement();
    
    printf("Testing GetHscore_test_value...\n");
    bool test2_passed = GetHscore_test_value();
    
    printf("Testing CoinWithBag_test_collide...\n");
    bool test3_passed = CoinWithBag_test_collide();
    
    printf("Testing CoinWithBoundary_test_collide...\n");
    bool test4_passed = CoinWithBoundary_test_collide();

    // Print out the result of this test
    if (test1_passed) {
        printf("...Passed!\n");
    }
    else {
        printf("...Failed!\n");
        ++n_tests_failed; // Increment number of failures
    }
    if (test2_passed) {
        printf("...Passed!\n");
    }
    else {
        printf("...Failed!\n");
        ++n_tests_failed; // Increment number of failures
    }
    if (test3_passed) {
        printf("...Passed!\n");
    }
    else {
        printf("...Failed!\n");
        ++n_tests_failed; // Increment number of failures
    }
    if (test4_passed) {
        printf("...Passed!\n");
    }
    else {
        printf("...Failed!\n");
        ++n_tests_failed; // Increment number of failures
    }

    // Finish by printing a summary of the tests
    if (n_tests_failed > 0) {
        printf("%d tests FAILED!\n", n_tests_failed);
    }
    else {
        printf("All tests passed!\n");
    }

    return n_tests_failed;
}

#endif