/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name:Zikang Qian
Username: yzjdxl
Student ID Number: 201189213
Date: 2/5/2018
*/

///////// pre-processor directives ////////
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "GameEngine.h"

#ifdef WITH_TESTING
#include "tests.h"
#endif

#define BAG_WIDTH 15
#define BAG_HEIGHT 2
#define COIN_SIZE 2
#define COIN_SPEED 3
/////////////// structs /////////////////
struct UserInput {
    Direction d;
    float mag;
};
/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
GameEngine game;

///////////// prototypes ///////////////
void init();
void update_game(UserInput input);
void render();
void begin_text();
void rule_text();
void gameover_text();

///////////// functions ////////////////
int main()
{

#ifdef WITH_TESTING
    int number_of_failures = run_all_tests();

    if(number_of_failures > 0) return number_of_failures;
#endif

    int fps = 10;  // frames per second
    int nodead;
    
    do{ 
        init();     // initialise and then display start screen
        begin_text();  // waiting for the user to start
        lcd.clear(); 
        
        init();  // initialise and then display rule screen
        rule_text();  // waiting for the user to read the text
        
        render(); // first draw the initial frame 
        wait(1.0f/fps);  // and wait for one frame period
        
        // game loop - read input, update the game state and render the display  
        do{
            game.read_input(pad);
            nodead = game.update(pad);
            render();
            wait(1.0f/fps);
        }while(nodead);
        
        // escape the loop when missing a coin
        lcd.clear();  
        init();  // initialise and then display end screen
        gameover_text();  // waiting for the user to restart
         
    }while(1);
}

void render()
{
    // clear screen, re-draw and refresh
    lcd.clear();  
    game.draw(lcd);
    lcd.refresh();
}

// initialies all classes and libraries
void init()
{
    // need to initialise LCD and Gamepad 
    lcd.init();
    pad.init();
    // initialise the game with correct coin and bag sizes
    game.init(BAG_WIDTH,BAG_HEIGHT,COIN_SIZE,COIN_SPEED);
}

// simple splash screen displayed on start-up
void begin_text() {
    
    lcd.printString("Monopoly",17,2);  
    lcd.printString("Press START",10,5);
    lcd.refresh();
     
    // wait flashing LEDs until start button is pressed 
    while (pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}

void rule_text() {
 
    lcd.printString("Take the coins",0,1);
    lcd.printString("as many as",0,2);
    lcd.printString("possible!",0,3);
    lcd.printString("Press START",10,5);
    lcd.refresh();
     
    // wait flashing LEDs until start button is pressed 
    while (pad.check_event(Gamepad::START_PRESSED) == false);
 }
 // simple splash screen displayed on game-over
 void gameover_text() {
    
    lcd.printString("Game Over!",13,2);  
    lcd.printString("Press BACK",10,5);
    lcd.refresh();
     
    // wait flashing LEDs until back button is pressed 
    while ( pad.check_event(Gamepad::BACK_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}