#ifndef BAG_H
#define BAG_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Bag Class
* @brief Create a bag moved by player at the bottom
* @author Zikang Qian
* @date April, 2018
*/

class Bag
{
    
public:

    /** Constructor */
    Bag();
    
    /** Destructor */
    ~Bag();
    
    /** Initiate the bag position and bag size
     * @param the value of the bag position(int), bag height(int) and bag width(int)
     */
    void init(int y,int height,int width);
    
    /** Show bag figure on screen
     * @param the figrue of bag (lcd)
     */
    void draw(N5110 &lcd);
    
    /** Output the movement of bag
     * @param the direction of movement(direction)
     */
    void update(Direction direction,float mag);
    
    /** Calculate the getten score
     * @param the value of current score and highest score
     */
    void add_score();
    
    /** Get the score
     * @return the current score
     */
    int get_score();
    
    /** Get the score
     * @return the highest score
     */
    int get_Hscore();
    
    /** Get the location of bag
     * @return the x location and y location of bag
     */
    Vector2D get_bag_position();

private:

    int bag_height;
    int bag_width;
    int bag_x;
    int bag_y;
    int bag_speed;
    int _score;
    int _Hscore;

};

#endif