#ifndef COIN_H
#define COIN_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Bag.h"

/** Coin Class
* @brief Create coins falling from the top randomly
* @author Zikang Qian
* @date April, 2018
*/

class Coin
{

public:

    /** Constructor */
    Coin();
    
    /** Destructor */
    ~Coin();
    
    /** Initiate the coin size and coin initial speed
     * @param the value of the coin size (int) and coin speed (int)
     */
    void init(int size,int speed);
    
    /** Show coin figure on screen
     * @param the figrue of coin (lcd)
     */
    void draw(N5110 &lcd);
    
    /** Output the movement of coin
     * @param the velocity on y location (int)
     */
    void update();
    
    /** Test the position of coin
     * @param the position of coin
     */
    void set_coin_position(Vector2D p);
    
    /** Test the velocity of coin
     * @param the velocity of coin
     */
    void set_coin_velocity(Vector2D v);
    
    /** Get the position of coin for testing
     * @return position of coin on x location (int) and y location (int)
     */
    Vector2D get_coin_position();
    
private:

    int coin_size;
    int coin_x;
    int coin_y;
    
    Vector2D coin_velocity;
    
};

#endif