#include "Bag.h"

Bag::Bag()
{

}

Bag::~Bag()
{

}

void Bag::init(int y,int height,int width)
{
    bag_x = WIDTH/2 - width/2; // default x position of bag, depends on width of screen and width of bag
    bag_y = y;  // default y position of bag on screen is fixed
    bag_height = height; // height of bag figure, defined in main.cpp
    bag_width = width; //width of bag figure, defined in main.cpp
    bag_speed = 1;  // default speed
    _score = 0; // initial score is zero
}

void Bag::draw(N5110 &lcd)
{
    // draw bag in screen 
    lcd.drawRect(bag_x,bag_y,bag_width,bag_height,FILL_BLACK);
}

void Bag::update(Direction direction,float mag)
{
    // the moving speed of bag
    bag_speed = int(mag*10.0f);  

    // the moving direction of bag
    if (direction == W) {
        bag_x-=bag_speed;
    } else if (direction == E) {
        bag_x+=bag_speed;
    }

    // check the x origin to ensure that the bag doesn't go outside screen
    if (bag_x < 1) {
        bag_x = 1;
    }
    if (bag_x > WIDTH - bag_width - 1) {
        bag_x = WIDTH - bag_width - 1;
    }

}

void Bag::add_score()
{
    // score is added when this function runs each time
    _score=_score++;
    
    // store the highest score
    if (_score >= _Hscore) {
        _Hscore = _score;
    } 
}

int Bag::get_score()
{
    // return the value of current score
    return _score;
}

int Bag::get_Hscore()
{
    // return the value of highest score
    return _Hscore;
}
            
Vector2D Bag::get_bag_position() {
    Vector2D p = {bag_x,bag_y};
    // return the coordinate of bag
    return p;    
}