#include <mbed.h> 
#include "SparkFun_APDS9960.h"
#include "led.h"

//Serial pc(P0_23,P0_25);   // TX Pin, RX Pin
Serial pc(P0_23,P0_8); 
I2C i2c(P0_14, P0_13); 
SparkFun_APDS9960 apds(i2c);
InterruptIn SparkFun_Int(P0_16);
PwmOut Fan1(P0_9);
PwmOut Fan2(P0_25);

//Red_Left: P0.8    Blue_Right:P0.11    Green_Down:P0.15

DigitalOut LED_Down(P0_15);

int isr_flag = 0;

void handleGesture();
 

void SparkFun_Interrupt(){
  isr_flag = 1;   
}

 int main()
 {
     pc.baud(9600);
     pc.printf("Hello world!\n"); 
     Fan1 = 0;Fan2 = 0;
     LED_Down = 1;
     wait_ms(500); wait_ms(500); wait_ms(500); wait_ms(500); 
     LED_Down = 0;
     SparkFun_Int.fall(&SparkFun_Interrupt);
        
     
     if(apds.init(100000))
        pc.printf("APDS-9960 initialization complete\n");
     else
        pc.printf("Something went wrong during APDS-9960 init!\n");
        
     if (apds.enableGestureSensor(true) ) 
        printf("Gesture sensor is now running\n");
     else 
       printf("Something went wrong during gesture sensor init!\n");
    
     Fan1.period(1/40);
     Fan2.period(1/40);
     Fan1 = 1; Fan2 = 1;
        
     while(1)
     {
        if(isr_flag == 1)
        {
            handleGesture();
            isr_flag = 0;
        } 
    }
 }
 
 void handleGesture() {
    if ( apds.isGestureAvailable() ) {
    switch ( apds.readGesture() ) {
      case DIR_UP:
      
        pc.printf("Left\n");
        if(Fan1.read() != 0.95)
            Fan1 = 0.95;
        if(Fan2.read() != 1)
            Fan2 = 1;
        break;
        
      case DIR_DOWN:
      
        pc.printf("Right\n");
        if(Fan1.read()!= 1)
            Fan1 = 1;
        if(Fan2.read()!= 0.95)
            Fan2 = 0.95;
            
        break;
      case DIR_LEFT:
        LED_Down = 0;
        pc.printf("Down\n");
        break;
      case DIR_RIGHT:
        pc.printf("Up\n");
        LED_Down = 1;
        break;
      case DIR_NEAR:
        pc.printf("NEAR\n");
        break;
      case DIR_FAR:
        pc.printf("FAR\n");
        break;
      default:
        pc.printf("NONE\n");
    }
  }
}