#include "mbed.h"
#include "BaseDAC.h"
#include "Button.h"
#include "ConstantOutput.h"
#include "SineWave.h"
#include "SquareWave.h"
#include "MicrochipDAC.h"
#include "ChipConstant.h"
#include "ChipSine.h"
#include "ChipSquare.h"

#include <sstream>
#include <vector>
#include <string>



string namedsc;

int main()
{
    Button button(PA_0);
    Serial serial(PA_2, PA_3);


    ChipConstant chipConstant (PA_6,PA_7,PA_5,PA_8);
    ChipSine chipSine (PA_6,PA_7,PA_5,PA_8);
    ChipSquare chipSquare (PA_6,PA_7,PA_5,PA_8);
    
    vector<MicrochipDAC*>microchipDACs;
     microchipDACs.push_back(&chipConstant);
     microchipDACs.push_back(&chipSine);
     microchipDACs.push_back(&chipSquare);
    
    DigitalOut myled(PD_14);

    //vector<DAC*>DACs;
    // DACs.push_back(&microchipDAC);
    //DACs.push_back(&baseDAC);

    //BaseDAC baseDAC (PA_4);
    ConstantOutput constantOutput(&serial);
    SineWave sineWave(&serial);
    SquareWave squareWave(&serial);
    vector<BaseDAC*>baseDACs;
    baseDACs.push_back(&constantOutput);
    baseDACs.push_back(&sineWave);
    baseDACs.push_back(&squareWave);


    while(1) {


        serial.puts("Plese type the name of signal:sine, constant or square. \r\n");

        char buffer[128];
        buffer[0]=0;
        serial.scanf("%127[^\r\n]", buffer);
        string buffer_str(buffer);
        istringstream iss(buffer_str);

        string name;
        float amplitude = 0.0;
        float frequency = 0.0;
        
        iss >> name;

        int i;
        if (name =="constant") {
            i = 0;
            serial.puts("The function is running.\r\n");
        } else if (name == "sine") {
            i = 1;
            serial.puts("The function is running.\r\n");
        } else if (name == "square")
            i = 2;
        else {
            serial.puts("The name of function is invalid.\r\n");
            i = 100;
        }



        iss >> amplitude;
        if (amplitude <= 0) {
            serial.puts("The value of amplitude is invalid.Please type again.\r\n");
        }



        iss >> frequency;
        if (frequency < 0) {
            serial.puts ("The value of frequency is invalid.\r\n");
        }

        iss >> namedsc;
        if (namedsc =="base") {
            baseDACs[i]->setAmplitude();
            baseDACs[i]->setFrequency();
            baseDACs[i]->run();
            baseDACs[i]->start();
        

        if (button.isPressed()) {
            myled = 1;

            // baseDACs[i]->run();
            serial.puts("The function is stopped.\r\n");
            baseDACs[i]->stop();
        } else baseDACs[i]->start();

    

} else if(namedsc =="chip") {
         serial.puts("Chip runs.\r\n");
        microchipDACs[i]->setOutput(amplitude,frequency);
        
            
        } else serial.puts("The name of DAC is invalid.Function cannot run.\r\n");


}

}

