// Hello World example for the USBMIDI library

#include "mbed.h"
#include "USBMIDI.h"
#include <string>
#include <list>

#include <mpr121.h>
AnalogIn laser1 (p20);
AnalogIn laser2(p19);
AnalogIn laser3(p18);
AnalogIn laser4(p17);
AnalogIn laser5(p16);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

char str1[100];
char str2[100];
char str3[100];
char str4[100];
char str5[100];
Serial pc(USBTX,USBRX);
float val1 = 1;
float val2 = 1;
float val3 = 1;
float val4 = 1;
float val5 = 1;
int flag1 = 0;
int flag2 = 0;
int flag3 = 0;
int flag4 = 0;
int flag5 = 0;

int interupt = 0;
void show_message(MIDIMessage msg)
{
    switch (msg.type()) {
        case MIDIMessage::NoteOnType:
            printf("NoteOn key:%d, velocity: %d, channel: %d\n", msg.key(), msg.velocity(), msg.channel());
            break;
        case MIDIMessage::NoteOffType:
            printf("NoteOff key:%d, velocity: %d, channel: %d\n", msg.key(), msg.velocity(), msg.channel());
            break;
        case MIDIMessage::ControlChangeType:
            printf("ControlChange controller: %d, data: %d\n", msg.controller(), msg.value());
            break;
        case MIDIMessage::PitchWheelType:
            printf("PitchWheel channel: %d, pitch: %d\n", msg.channel(), msg.pitch());
            break;
        default:
            printf("Another message\n");
    }
}

InterruptIn interrupt(p26);
// Setup the i2c bus on pins 28 and 27
I2C i2c(p9, p10);

// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

int fs;
int octave;
void fallInterrupt() {
    int fs_code=0;
    int oct_code = 0;
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    // LED demo mod by J. Hamblen
    //pc.printf("MPR value: %x \r\n", value);
    i=0;
    // puts key number out to LEDs for demo
    for (i=0; i<4; i++) {
        if (((value>>i)&0x01)==1) fs_code=i+1;
        }
    switch (fs_code)
    {
        case 1:
        fs = 1;
        led1 = 1;
        led2 = 0;
        break;
        case 2:
        fs = 0;
        led1 = 0;
        led2 = 0;
        break;
        case 3:
        fs = -1;
        led1 = 0;
        led2 = 1;
        break;
        case 4:
        fs = 0;
        octave = 0;
        led1 = 0;
        led2 = 0;
        led3 = 0;
        led4 = 0;
        break;
    }
                        
    for (i=4; i<7; i++) {
        if (((value>>i)&0x01)==1) oct_code=i;
    }
    switch (oct_code)
    {
        case 4:
        octave = 12;
        led3= 1;
        led4 = 0;
        break;
        case 5:
        octave = 0;
        led3 = 0;
        led4 = 0;
        break;
        case 6:
        octave = -12;
        led3 = 0;
        led4 = 1;
        break;
    }

}

USBMIDI midi;

float lightScale(float val, float light)
{
    val = light;
    return val;
}


int main()
{
    pc.baud(19200);
    midi.attach(show_message);         // call back for messages receive
    
    while (1) {
        fallInterrupt();
        float light1 = laser1;
        float light2 = laser2;
        float light3 = laser3;
        float light4 = laser4;
        float light5 = laser5;
        float pval1 = val1;
        float pval2 = val2;
        float pval3 = val3;
        float pval4 = val4;
        float pval5 = val5;
        val1 = lightScale(val1, light1);
        val2 = lightScale(val2, light2);
        val3 = lightScale(val3, light3);
        val4 = lightScale(val4, light4);
        val5 = lightScale(val5, light5);
        sprintf (str1, "light value 1 = %04f\n", light1);
        sprintf (str2, "light value 2= %04f\n", light2);
        sprintf (str3, "light value 3= %04f\n", light3);
        sprintf (str4, "light value 4= %04f\n", light4);
        sprintf (str5, "light value 5= %04f\n", light5);
        //wait(1);
        pc.printf(str1);
        pc.printf(str2);
        pc.printf(str3);
        pc.printf(str4);
        pc.printf(str5);

        if (val1 <0.7 && pval1 > 0.7) {
            flag1 = 1;
        } else if (val1 < 0.7 && flag1 ==1) {
            midi.write(MIDIMessage::NoteOn(60+fs+octave));
            flag1 = 0;
        } else if (val1 >0.7) {
            midi.write(MIDIMessage::NoteOff(60+fs+octave));
            flag1 = 0;
        }
        if (val2 <0.7 && pval2 > 0.7) {
            flag2 = 1;
        } else if (val2 < 0.7 && flag2 ==1) {
            midi.write(MIDIMessage::NoteOn(62+fs+octave));
            flag2 = 0;
        } else if (val2 >0.7) {
            midi.write(MIDIMessage::NoteOff(62+fs+octave));
            flag2 = 0;
        }
        if (val3 <0.7 && pval3 > 0.7) {
            flag3 = 1;
        } else if (val3 < 0.7 && flag3 ==1) {
            midi.write(MIDIMessage::NoteOn(64+fs+octave));
            flag3 = 0;
        } else if (val3 >0.7) {
            midi.write(MIDIMessage::NoteOff(64+fs+octave));
            flag3 = 0;
        }
        if (val4 <0.7 && pval4 > 0.7) {
            flag4 = 1;
        } else if (val4 < 0.7 && flag4 ==1) {
            midi.write(MIDIMessage::NoteOn(65+fs+octave));
            flag4 = 0;
        } else if (val4 >0.7) {
            midi.write(MIDIMessage::NoteOff(65+fs+octave));
            flag4 = 0;
        }
        if (val5 <0.7 && pval5 > 0.7) {
            flag5 = 1;
        } else if (val5 < 0.7 && flag5 ==1) {
            midi.write(MIDIMessage::NoteOn(67+fs+octave));
            flag5 = 0;
        } else if (val5 >0.7) {
            midi.write(MIDIMessage::NoteOff(67+fs+octave));
            flag5 = 0;
        }
    }
}