#ifndef VerticalEstimator_h
#define VerticalEstimator_h

#include "mbed.h"
#include "Library.h"
#include "VL53L0X.h"


// Vertical estimator class
class VerticalEstimator
{
public :
//Class constructor
    VerticalEstimator () ;
// Initialize class
    void init () ;
// Predict vertical position and velocity from model
    void predict () ;
// Correct vertical position and velocity with measurement
    void correct (float phi, float theta);
// Vertical position (m) and velocity (m/s) estimation
    float w_est, z_est;
    /*
    float w_est;
    float z_est;
    float wm;
    float zm ;//definido uma leitura para distancia vertical
    float zml ;//definindo uma segunda leitura para calcular a velocidade vertical
    */

private :
// Range sensor object
    VL53L0X range ;
// Last vertical position (m) measurement
    float z, w, zml, wm, zm;
};

# endif
