/*
    Taku Hachisu 06/01/2017

    Footile demo for WHC2017
*/

#ifndef FOOTILE_H
#define FOOTILE_H

#include "mbed.h"
#include "DRV2605.h"

#include "wave.h"



class Footile
{

public:
    /**
        Constructor for Footile Objects
    */
    Footile(PinName led1, PinName led2, PinName led3, PinName trg, PinName ad, PinName tx, PinName rx, PinName io1, PinName io2, PinName sda, PinName scl, PinName en);

    /**
        functions
    */
    void doFunctions(void);

private:
    DRV2605 _Vibration;
    DigitalOut _led1;   // for debugging
    DigitalOut _led2;   // for debugging
    DigitalOut _led3;   // for debugging
    DigitalOut _trg;
    //PwmOut _trg;
    AnalogIn _prssr;
    Serial _bt;
    DigitalOut _btDummy1; // LPC11U24 does not support flow control
    DigitalOut _btDummy2; // LPC11U24 does not support flow control
    Ticker _heart;
    Ticker _trans;
    
    Ticker _viber;
    Ticker _pwmviber;
    
    int _volumeBuf;
    int _SquareVolume;
    int _C_Volume;
    float _sens;
    char _buf[5];
    int _countSize;
    int _on;
    
    int count_u;
    int count_pwm;
    int _trg_flag;
    int count_led2;
    
    bool ChangeFlag;
    bool ChangeFlag2;
    bool SteadyON;
    bool VibeON;
    bool SetDutyMode;
    bool leafMode;
    bool SteadyMode;
    bool SinewaveMode;
    bool CorrespondMode;
    bool ConnectCheck;
    bool snowMode;
    bool grassMode;
    bool gravelMode;
    
    void _onReceive(void);
    void _beat(void);
    void _transmission(void);
    unsigned short ctoi(char c);
    void _modeChange(unsigned short c);
    void VibeTimer();
    void OnVibe(const float* wave, int size);
    void PwmDuty(int d);
    void PwmVibe();
    
};

#endif