#include "Footile.h"
#include <math.h>

//myFootile(P0_8, P0_9, P0_10, P0_11, P0_12, P0_19, P0_18, P0_7, P0_17, P0_5, P0_4, P0_22);
Footile::Footile(PinName led1, PinName led2, PinName led3, PinName trg, PinName ad, PinName tx, PinName rx, PinName io1, PinName io2, PinName sda, PinName scl, PinName en):
    _led1(led1), _led2(led2), _led3(led3), _trg(trg), _prssr(ad), _bt(tx, rx), _btDummy1(io1), _btDummy2(io2), _Vibration(sda, scl, en)
{

    //_Vibration.i2cWriteByte(LIBRARY_SELECTION, _Vibration.LRA_LIB);
    //_Vibration.i2cWriteByte(MODE, _Vibration.PWM_ANALOG);
    

    _led1 = 1;
    _led2 = 1;
    _led3 = 1;
    _volumeBuf=255;
    _SquareVolume=64;
    _trg = 0;;
    count_u = 1;
    count_pwm = 0;
    _trg_flag - 0;
    count_led2 = 0;
    
    //flag
    /*
    SteadyMode=false;
    SinewaveMode=true;
    ChangeFlag=true;
    CorrespondMode=false;
    ConnectCheck=false;
    snowMode=false;
    grassMode=false;
    */
    SteadyMode=false;
    SinewaveMode=false;
    CorrespondMode=false;
    ChangeFlag=true;
    SteadyON=false; 
    VibeON=true;
    ChangeFlag2=false; 
    SetDutyMode=false;
    
    snowMode=true;
    grassMode=false;
    gravelMode=false;
    leafMode=false;
    
    
    _sens=0.8;
    
    _countSize=0;
    
    _on=0;

    _trans.attach(this,&Footile::_transmission,0.5);
    _bt.attach(this, &Footile::_onReceive, Serial::RxIrq);
    _btDummy1 = 0;
    _btDummy2 = 0;
    
    
    //_Vibration.rtp((char)(255)); 
    
    _heart.attach(this, &Footile::_beat, 2.0);
}



void Footile::doFunctions()
{
    static int prv_on = 0,Volume=0;
    /*
    if(count_pwm == 0){
        _Vibration.pwm_analog();
        wait(0.001);
        //_pwmviber.attach(this, &Footile::PwmVibe,float(1.0)/(float(300)*float(50))); 
        _pwmviber.attach(this, &Footile::PwmVibe,float(1.0)/(float(300*128))); 
        //_pwmviber.attach(this, &Footile::PwmVibe,float(1.0)/float(300)); 
        count_pwm = 1;
    } 
    */

    // make hysteresis
    if(SteadyON==false){ 
        if(VibeON==true){
            if(_prssr > _sens){
                _on = 1;
                ChangeFlag2=true;
                ChangeFlag=false;
                _led1 = 1;
                if(count_pwm == 0){
                    _Vibration.pwm_analog();
                    wait(0.001);
                    //_pwmviber.attach(this, &Footile::PwmVibe,float(1.0)/(float(300)*float(50))); 
                    _pwmviber.attach(this, &Footile::PwmVibe,float(1.0)/(float(300*128))); 
                    //_pwmviber.attach(this, &Footile::PwmVibe,float(1.0)/float(300)); 
                    count_pwm = 1;
                }   
            }
            if(_prssr < _sens){
                //count_pwm = 0;
                ChangeFlag2=false;
                ChangeFlag=false;
                _led1 = 0;
                //Volume = 0;
                //_Vibration.rtp((char)(Volume));
                
            //if(_prssr < 0.2)
                //_pwmviber.detach();
                //count_pwm = 0;
                _on = 0;
            }
            
        }
        else{
            ChangeFlag2=false;
        }
    }else{
        ChangeFlag2=true;
    }
    
    /*
    if(ChangeFlag2==true){
        ChangeFlag=false;
        //_Vibration.pwm_analog();
    }
    else{
        
        if(_on && !prv_on||ChangeFlag==true) {
            //_trg = 1;
            //_trg = 0;
            _led1 = 0;
            Volume=_volumeBuf;
            //Volume=0;
            if(SinewaveMode==true){
                //_Vibration.rtp((char)(Volume)); 
            }
            _bt.printf("%d\n",_prssr);
        }
        if(!_on && prv_on||ChangeFlag==true) {
            //_trg = 0;
            _countSize=0;
            Volume=0;
            if(SteadyMode==false&&SinewaveMode==true){
                Volume=0;//When Not c=125
                //_Vibration.rtp((char)(Volume)); 
            }
        }
        
    }
    */
    prv_on = _on;

    
    if(snowMode==true||grassMode==true||gravelMode==true||leafMode==true){
        //_viber.attach(this, &Footile::VibeTimer,0.001);
        //_viber.attach(this, &Footile::VibeTimer,0.00667);
    } else{
       //_viber.detach(); 
       //_pwmviber.detach();
    }
    
    ChangeFlag=false;
        
    if(CorrespondMode==true){
        if(ChangeFlag2 != true){  
            //_Vibration.rtp((char)(_volumeBuf*_prssr));
        }
    }
    wait(0.001);
}
void Footile::PwmDuty(int d){
    if(_trg_flag == 1){
        if(count_u <= d){
            count_u += 1;
        }
        else{
            _trg_flag = 0;
            _trg = 0;
            count_u = 1;
        }
    }
    else{
        if(count_u <= 256-d){
            count_u += 1;
            _trg = 0;
            _trg_flag = 0;
        }
        else{
            _trg = 1;
            count_u = 1;
            _trg_flag = 1;
        } 
    }
}
void Footile::PwmVibe(){
    if(ChangeFlag2 == true){
        /*
        if(_trg_flag == 1){
            if(count_u <= _SquareVolume){
                count_u += 1;
            }
            else{
                _trg_flag = 0;
                _trg = 0;
                count_u = 1;
            }
        }
        else{
            if(count_u <= 256-_SquareVolume){
                count_u += 1;
                _trg = 0;
                _trg_flag = 0;
            }
            else{
                _trg = 1;
                count_u = 1;
                _trg_flag = 1;
            } 
        }
        */
        if(SetDutyMode==false){
            PwmDuty(_SquareVolume);
        }
        else{
            PwmDuty(_C_Volume);
        }
    }else{
        _trg = !_trg;
        count_u = 1; 
    } 
}

void Footile::OnVibe(const float* wave, int size){
    //static int square_volume = 0;
    //ChangeFlag2=true;
    //ChangeFlag=false;
    //_Vibration.pwm_analog();
    //_volumeBuf = 0;
    //Volume = 0;
    //_pwmviber.attach(this, &Footile::PwmVibe,0.5); 
    //_pwmviber.attach(this, &Footile::PwmVibe,float(1.0)/(float(300.0)*float(128))); 
    //_pwmviber.attach(this, &Footile::PwmVibe,float(1.0)/(float(300)*float(50))); 
    //_pwmviber.attach(this, &Footile::PwmVibe,float(1.0)/float(300)); 
    //_trg.period(float(1.0/150.0));
    //_trg = 0.5;
    //_pwmviber.attach(this, &Footile::PwmVibe,0.005); 
    /*
    if(_countSize < size){
        //_Vibration.rtp((char)(wave[_countSize]*255)*);
          square_volume = _volumeBuf;
          _Vibration.rtp((char)(wave[_countSize]*square_volume));
            //_Vibration.PWM_ANALOG((char)(wave[_countSize]*square_volume));
            _countSize++;
    }
    else  {
            _Vibration.rtp((char)0);     
    }
    */
}


void Footile::VibeTimer(){
    if(_on==1&&snowMode==true){
        //_Vibration.pwm_analog();
        ChangeFlag2=true;
        ChangeFlag=false;
        /*
        if(count_pwm == 0){
            _Vibration.pwm_analog();
            wait(0.001);
            //_pwmviber.attach(this, &Footile::PwmVibe,float(1.0)/(float(300)*float(50))); 
            _pwmviber.attach(this, &Footile::PwmVibe,float(1.0)/(float(300*128))); 
            //_pwmviber.attach(this, &Footile::PwmVibe,float(1.0)/float(300)); 
            count_pwm = 1;
        } 
        */  
        //_viber.detach(); 
        //OnVibe(snowwave500, (int)(sizeof(snowwave500)/sizeof(snowwave500[0])));
    }else if(_on==0&&snowMode==true){
        ChangeFlag2=false;
        ChangeFlag=false;
        //_pwmviber.detach();
        //count_pwm = 0;
    }else if(_on==1&&grassMode==true){
        OnVibe(leafwave2, (int)(sizeof(leafwave2)/sizeof(leafwave2[0])));
        //OnVibe(grasswave, (int)(sizeof(grasswave)/sizeof(grasswave[0])));
        //OnVibe(squarewave, (int)(sizeof(squarewave)/sizeof(squarewave[0])));
        //OnVibe(gravelwave, (int)(sizeof(gravelwave)/sizeof(gravelwave[0])));
    }else if(_on==1&&gravelMode==true){
        OnVibe(gravelwave, (int)(sizeof(gravelwave)/sizeof(gravelwave[0])));
    }else if(_on==1&&leafMode==true){
        //OnVibe(leafwave2, (int)(sizeof(leafwave2)/sizeof(leafwave2[0])));
        //OnVibe(heelwave, (int)(sizeof(heelwave)/sizeof(heelwave[0])));
        //OnVibe(snowwave2, (int)(sizeof(snowwave2)/sizeof(snowwave2[0])));
        //OnVibe(grasswave, (int)(sizeof(grasswave)/sizeof(grasswave[0])));
        OnVibe(squarewave, (int)(sizeof(squarewave)/sizeof(squarewave[0])));
        //OnVibe(waterwave1, (int)(sizeof(waterwave1)/sizeof(waterwave1[0])));
    }
    else if(_on==0){
        if(ChangeFlag2 != true){ 
            //_Vibration.rtp((char)0);  
        }  
    }
}










// interruption on receiving
void Footile::_onReceive(void)
{
    unsigned short num[5];
    unsigned short data_index = 0;
    unsigned short index;
    unsigned short data=0;
    
    ConnectCheck=true;
    
    for(int i=0;i<sizeof(num);i++){
        num[i]=0;    
    }

    while(1) {
        if (!_bt.readable()) continue;
        
        char let = _bt.getc();
        //_bt.printf("%c",let);
        data_index++;
        
        if (let == '\n')
        {
           // num[data_index-1] = 0;
            break;          
        }else{
            num[data_index]=let-'0';
            }
    }
        
    index=data_index-1; 
    
    for(int i=0;i<data_index-1;i++){
        data+=(unsigned short)(pow(10.0,(double)i))*num[index];//get unsigned short values
        index--;
    }
     
     data_index = 0;
    // echo back    
    _bt.printf("%d",data);
    _modeChange(data);
    data=0;
   
}












void Footile:: _modeChange(unsigned short c){
    
        // PWM mode
    if(c == 0) {
        SteadyMode=false;
        SinewaveMode=true;
        //ChangeFlag=true;
        ChangeFlag2=false;
        CorrespondMode=false;
        snowMode=false;
        grassMode=false;
        gravelMode=false;
        leafMode=false;
        SteadyON=false; 
        VibeON=true;
        /*
        _Vibration.i2cWriteByte(MODE, _Vibration.PWM_ANALOG);
        _heart.attach(this, &Footile::_beat, 1.0);
        ChangeFlag=true;*/
        
        // Wavefrom sequencer mode
    } else if (0 < c && c <= 123) { //Change waveform
        SteadyMode=false;
        SinewaveMode=false;
        ChangeFlag=false;
        ChangeFlag2=false;
        CorrespondMode=false;
        snowMode=false;
        grassMode=false;
        gravelMode=false;
        leafMode=false;
        _Vibration.i2cWriteByte(WAVEFORM_SEQUENCER_1, c);
        _Vibration.i2cWriteByte(MODE, _Vibration.EXTERNAL_LEVEL);
        _heart.attach(this, &Footile::_beat, 1.0);
        // Standby mode
        
    }else if(c==124){   //SteadyMode
        SteadyMode=true;
        SinewaveMode=true;
        ChangeFlag=true;
        ChangeFlag2=false;
        CorrespondMode=false;
        snowMode=false;
        grassMode=false;
        gravelMode=false;
        leafMode=false;
        SteadyON=true; 
        //VibeON=false;
    }else if (125<=c&&c<=255) {   //Change Magnituide
        if(SteadyMode==false&&SinewaveMode==false){
            ChangeFlag=false;    
        }else{
            ChangeFlag=true;
        }
        if(c>=190){
            _SquareVolume = c-190;
        }
        _volumeBuf = (c-125)*255/(255-125);
        
    }else if(c==256){ //Change Amplitude Mode
        CorrespondMode=true;
        ChangeFlag=false;
    }else if(257<=c&&c<=261){   //Change Sensitvty(257<=c<=266)
        _sens=(c-257)*0.5/4.0+0.3;
    }else if(262<=c&&c<=266){
        _sens=(c-262)*0.15/4.0+0.8;
    }
    
    else if(c==267){
        SteadyMode=false;
        SinewaveMode=false;
        CorrespondMode=false;
        ChangeFlag=true;
        snowMode=true;
        grassMode=false;
        gravelMode=false;
        leafMode=false;
        count_pwm = 0;
    }else if(c==268){
        SteadyMode=false;
        SinewaveMode=false;
        CorrespondMode=false;
        ChangeFlag=true;
        snowMode=false;
        grassMode=true;  
        gravelMode=false;
        leafMode=false;
        count_pwm = 0;      
    }else if(c==269){
        SteadyMode=false;
        SinewaveMode=false;
        CorrespondMode=false;
        ChangeFlag=true;
        snowMode=false;
        grassMode=false; 
        gravelMode=true;
        leafMode=false;  
        count_pwm = 0;    
    }else if(c==270){
        SteadyMode=false;
        SinewaveMode=false;
        CorrespondMode=false;
        ChangeFlag=true;
        snowMode=false;
        grassMode=false; 
        gravelMode=false;
        leafMode=true; 
        count_pwm = 0;
  
    }else if (300<=c&&c<=428) {   //Change Magnituide
        if(SteadyMode==false&&SinewaveMode==false){
            ChangeFlag=false;    
        }else{
            ChangeFlag=false;
        }
        _SquareVolume = c-300;        
    }else if (c==501) {   //Change Magnituide
          _C_Volume=_SquareVolume;  
    }else if (c==502) {   //Change Magnituide
          SetDutyMode = true;  
    }else if (c==503) {   //Change Magnituide
        SetDutyMode = false;  
    }else if (c==504) {   //Change Magnituide
        VibeON = false;  
    }else {
        _Vibration.i2cWriteByte(MODE, _Vibration.STANDBY);
        _heart.attach(this, &Footile::_beat, 2.0);
    }    
}

void Footile::_transmission(void)
{
    _bt.printf("a");
    
    if(ConnectCheck==true){
        _trans.detach();
    }
}


// heart beat
void Footile::_beat(void)
{
    if(count_led2<=3){
    _led2 = !_led2;
    count_led2 += 1;
    }
}