/*intの数をchar型の欲しいbyte数に変換*/
#include "splitData.h"
#include <cstdlib>
#include "math.h"


//////////////Intobyte内の関数
void limitDataForByte(int data,int byte);//指定のbyteで送れる量に制限.
void SplitToAbsData(int wannaChange,int byte,char *candata,int firstElement);//絶対値をcharに分解
void PutSignInTheLeft(int wannaChange,int byte,char *candata,int firstElement);
int Intsign(int num);//int型の数の符号を返す関数。正なら1,負なら-1


void Intobyte(int wannaChange,int byte,char *candata,int firstElement)//指定されたbyte数のchar型に分解.一番左に符号
{
    limitDataForByte(wannaChange, byte);
    SplitToAbsData(wannaChange,byte,candata,firstElement);
    PutSignInTheLeft(wannaChange,byte,candata,firstElement);
}


void limitDataForByte(int data,int byte)//指定のbyteで送れる量に制限.
{
    int limit=1<<(8*byte-1); //一番左に1
    if( abs(data) >= limit) {
        data=Intsign(data)*(limit-1);
    }

}

//絶対値をcharに分解
void SplitToAbsData(int wannaChange,int byte,char *candata,int firstElement)
{
    int absdata = abs(wannaChange);
    for(int i=0; i<byte; i++)
        candata[i+firstElement]=(absdata>>8*i)&255;
}
void PutSignInTheLeft(int wannaChange,int byte,char *candata,int firstElement)
{
    if(wannaChange<0) {
        int lastElement=firstElement+byte-1;
        candata[lastElement]+=128;
    }
}
int Intsign(int num)//int型の数の符号を返す関数。正なら1,負なら-1
{
    return (num>0)-(num<0); //num>0の時(num>0)=1,num<=0で(num>0)=0であることを利用。
}